/*
 * Copyright  2004-2005 The KGS Lab. / NAGASAWA Takahiro
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
/*
 * $Id: DefaultPasswordCallback.java,v 1.2 2005/04/28 01:13:29 mashu Exp $
 */
package cx.ath.kgslab.spring.wss.util;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

import org.apache.ws.security.WSPasswordCallback;

/**
 * ݒ肵UserIDɍvꍇɂ̂݁Aݒ肵pX[hԂR[obNNXB
 * @author NAGASAWA Takahiro
 */
public class DefaultPasswordCallback implements CallbackHandler {
  private String password;
  private String userId;

  /**
   * @param password The password to set.
   */
  public final void setPassword(String password) {
    this.password = password;
  }

  /**
   * @param userid The userid to set.
   */
  public final void setUserId(String userid) {
    this.userId = userid;
  }

  /**
   * @see javax.security.auth.callback.CallbackHandler#handle(javax.security.auth.callback.Callback[])
   */
  public void handle(Callback[] callbacks)
    throws IOException, UnsupportedCallbackException {
    for (int i = 0; i < callbacks.length; i++) {
      if (callbacks[i] instanceof WSPasswordCallback) {
        WSPasswordCallback pc =
          (WSPasswordCallback) callbacks[i];

        if (userId.equals(pc.getIdentifer())) {
          pc.setPassword(this.password);
        }
      } else {
        throw new UnsupportedCallbackException(callbacks[i],
          "Unrecognized Callback");
      }
    }
  }
}
