/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.spring.axis;

import cx.ath.kgslab.spring.axis.deployment.WSDDSpringHandler;
import org.apache.axis.AxisEngine;
import org.apache.axis.Handler;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.deployment.wsdd.WSDDChain;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.deployment.wsdd.WSDDHandler;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringAxisService
extends Service
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext context = null;
    private Handler[] requestFlow = null;
    private Handler[] responseFlow = null;

    public void afterPropertiesSet() throws Exception {
        AxisEngine engine = this.getEngine();
        WSDDEngineConfiguration configuration = (WSDDEngineConfiguration)engine.getConfig();
        WSDDDeployment deployment = configuration.getDeployment();
        WSDDGlobalConfiguration globalConfig = new WSDDGlobalConfiguration();
        WSDDRequestFlow wsddRequestFlow = new WSDDRequestFlow();
        globalConfig.setRequestFlow(wsddRequestFlow);
        this.addToChain((WSDDChain)wsddRequestFlow, this.requestFlow);
        WSDDResponseFlow wsddResponseFlow = new WSDDResponseFlow();
        globalConfig.setResponseFlow(wsddResponseFlow);
        this.addToChain((WSDDChain)wsddResponseFlow, this.responseFlow);
        deployment.setGlobalConfiguration(globalConfig);
        globalConfig.deployToRegistry(deployment);
    }

    private void addToChain(WSDDChain chain, Handler[] handlers) {
        if (handlers != null) {
            int i = 0;
            while (i < handlers.length) {
                Handler element = handlers[i];
                WSDDSpringHandler handler = new WSDDSpringHandler(element);
                chain.addHandler((WSDDHandler)handler);
                ++i;
            }
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public final Handler[] getRequestFlow() {
        return this.requestFlow;
    }

    public final void setRequestFlow(Handler[] requestFlow) {
        this.requestFlow = requestFlow;
    }

    public final Handler[] getResponseFlow() {
        return this.responseFlow;
    }

    public final void setResponseFlow(Handler[] responseFlow) {
        this.responseFlow = responseFlow;
    }
}

