/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.spring.axis.deployer;

import cx.ath.kgslab.spring.axis.DeployFailedException;
import cx.ath.kgslab.spring.axis.deployer.Deployer;
import cx.ath.kgslab.spring.axis.deployment.WSDDSpringService;
import cx.ath.kgslab.spring.axis.exporter.AxisExporter;
import cx.ath.kgslab.spring.axis.exporter.AxisServiceExporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceDeployer
implements Deployer {
    private static final Log logger;
    private ServletContext context = null;
    private WSDDDeployment deployment = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cx.ath.kgslab.spring.axis.deployer.ServiceDeployer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public void deploy(AxisExporter arg) {
        if (!(arg instanceof AxisServiceExporter)) {
            throw new IllegalArgumentException();
        }
        AxisServiceExporter exporter = (AxisServiceExporter)arg;
        WSDDSpringService service = this.createWSDDSpringService(exporter);
        this.deployment.deployService((WSDDService)service);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("service deployed : " + service.getQName()));
        }
    }

    protected WSDDSpringService createWSDDSpringService(AxisServiceExporter exporter) {
        WSDDSpringService result = null;
        try {
            String wsddFileName = exporter.getWsddFileName();
            if (wsddFileName != null && wsddFileName.length() > 0) {
                File wsddFile = new File(this.context.getRealPath(wsddFileName));
                result = new WSDDSpringService(exporter, this.getServiceElement(wsddFile));
            } else {
                result = new WSDDSpringService(exporter);
            }
            return result;
        }
        catch (WSDDException e) {
            throw new DeployFailedException(e);
        }
    }

    protected Element getServiceElement(File wsddFile) {
        try {
            FileInputStream is = new FileInputStream(wsddFile);
            Element documentElement = XMLUtils.newDocument((InputStream)is).getDocumentElement();
            Element[] serviceElements = this.getChildElements(documentElement, "service");
            if (serviceElements.length != 1) {
                throw new DeployFailedException("wsdd file missing : " + wsddFile.getPath());
            }
            return serviceElements[0];
        }
        catch (DeployFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeployFailedException(e);
        }
    }

    protected Element[] getChildElements(Element parent, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element element;
            Node thisNode = children.item(i);
            if (thisNode instanceof Element && (element = (Element)thisNode).getLocalName().equals(name)) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new Element[result.size()]);
    }

    public final void setContext(ServletContext context) {
        this.context = context;
    }

    public void setDeployment(WSDDDeployment deployment) {
        this.deployment = deployment;
    }
}

