/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.spring.axis.deployment;

import cx.ath.kgslab.spring.axis.TypeMappingDefinition;
import cx.ath.kgslab.spring.axis.deployment.WSDDSpringHandler;
import cx.ath.kgslab.spring.axis.exporter.AxisServiceExporter;
import cx.ath.kgslab.spring.axis.register.TypeMappingRegister;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.axis.Handler;
import org.apache.axis.constants.Use;
import org.apache.axis.deployment.wsdd.WSDDChain;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDHandler;
import org.apache.axis.deployment.wsdd.WSDDRequestFlow;
import org.apache.axis.deployment.wsdd.WSDDResponseFlow;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.w3c.dom.Element;

public class WSDDSpringService
extends WSDDService {
    protected static final Map providerMapping = new HashMap();
    private AxisServiceExporter serviceExporter;

    static {
        providerMapping.put("RPC", "SPRING_RPC");
        providerMapping.put("MSG", "SPRING_MSG");
    }

    public WSDDSpringService(AxisServiceExporter serviceExporter) throws WSDDException {
        this.serviceExporter = serviceExporter;
        String name = this.getName();
        this.setQName(new QName(name));
        JavaServiceDesc serviceDesc = (JavaServiceDesc)this.getServiceDesc();
        serviceDesc.setName(name);
        Class<?> serviceType = serviceExporter.getBean().getClass();
        this.setParameter("className", serviceType.getName());
        this.setProviderQName(new QName("http://xml.apache.org/axis/wsdd/providers/java", this.getSpringProvider(serviceExporter.getProvider())));
        String[] allowedMethods = serviceExporter.getAllowedMethods();
        this.initAllowedMethods(serviceExporter, allowedMethods);
        Object[] typeMappingDefs = serviceExporter.getTypeMappings();
        this.initTypeMappings(serviceDesc, typeMappingDefs);
        Handler[] requestFlow = serviceExporter.getRequestFlow();
        this.setRequestFlow((WSDDRequestFlow)this.initChain((WSDDChain)new WSDDRequestFlow(), requestFlow));
        Handler[] responseFlow = serviceExporter.getResponseFlow();
        this.setResponseFlow((WSDDResponseFlow)this.initChain((WSDDChain)new WSDDResponseFlow(), responseFlow));
    }

    public WSDDSpringService(AxisServiceExporter serviceExporter, Element serviceElement) throws WSDDException {
        super(serviceElement);
        this.serviceExporter = serviceExporter;
        String provider = this.getProviderQName().getLocalPart();
        this.setProviderQName(new QName("http://xml.apache.org/axis/wsdd/providers/java", this.getSpringProvider(provider)));
    }

    private WSDDChain initChain(WSDDChain chain, Handler[] handlers) {
        if (handlers != null) {
            int i = 0;
            while (i < handlers.length) {
                chain.addHandler((WSDDHandler)new WSDDSpringHandler(handlers[i]));
                ++i;
            }
        }
        return chain;
    }

    private void initAllowedMethods(AxisServiceExporter axisExporter, String[] allowedMethods) {
        if (allowedMethods != null && allowedMethods.length > 0) {
            this.setParameter("allowedMethods", this.getAllowedMethod(axisExporter));
        }
    }

    private void initTypeMappings(JavaServiceDesc serviceDesc, Object[] typeMappingDefs) throws WSDDException {
        TypeMappingRegister register = new TypeMappingRegister();
        if (typeMappingDefs != null) {
            int i = 0;
            while (i < typeMappingDefs.length) {
                TypeMappingDefinition typeMappingDef = null;
                if (typeMappingDefs[i] instanceof TypeMappingDefinition) {
                    typeMappingDef = (TypeMappingDefinition)typeMappingDefs[i];
                } else {
                    typeMappingDef = new TypeMappingDefinition();
                    if (typeMappingDefs[i] instanceof Class) {
                        typeMappingDef.setType((Class)typeMappingDefs[i]);
                    } else {
                        typeMappingDef.setType(typeMappingDefs[i].getClass());
                    }
                }
                this.addTypeMapping(register.createWSDDTypeMapping(typeMappingDef));
                ++i;
            }
        }
        this.initTMR();
        this.validateDescriptors();
        TypeMappingRegistry tmr = serviceDesc.getTypeMappingRegistry();
        TypeMapping tm = tmr.getTypeMapping(Use.DEFAULT.getEncoding());
        ((TypeMappingImpl)tm).setDoAutoTypes(true);
    }

    protected String getName() {
        String componentName = this.serviceExporter.getBeanName();
        return componentName;
    }

    protected String getSpringProvider(String provider) throws WSDDException {
        String s2Provider = (String)providerMapping.get(provider);
        if (s2Provider == null) {
            throw new WSDDException(provider);
        }
        return s2Provider;
    }

    private String getAllowedMethod(AxisServiceExporter exporter) {
        int i;
        HashSet<String> set = new HashSet<String>();
        String[] methods = exporter.getAllowedMethods();
        Class[] interfaces = exporter.getAllowedInterfaces();
        if (methods != null && methods.length > 0) {
            i = 0;
            while (i < methods.length) {
                set.add(methods[i]);
                ++i;
            }
        }
        if (interfaces != null && interfaces.length > 0) {
            i = 0;
            while (i < interfaces.length) {
                Class itfc = interfaces[i];
                this.getPublicMethodSetFromInterface(set, itfc);
                ++i;
            }
        }
        return this.createAllowedMethodsString(set);
    }

    private String createAllowedMethodsString(Set set) {
        if (!set.isEmpty() && !set.contains("*")) {
            StringBuffer buf = new StringBuffer();
            Iterator ite = set.iterator();
            while (ite.hasNext()) {
                String method = (String)ite.next();
                buf.append(method).append(' ');
            }
            String result = buf.toString().trim();
            if (result.length() > 0) {
                return result;
            }
        }
        return "*";
    }

    private void getPublicMethodSetFromInterface(Set set, Class itfc) {
        Method[] mthds;
        if (itfc.isInterface() && (mthds = itfc.getMethods()) != null && mthds.length > 0) {
            int j = 0;
            while (j < mthds.length) {
                Method method = mthds[j];
                if ((method.getModifiers() & 1) != 0) {
                    set.add(method.getName());
                }
                ++j;
            }
        }
    }

    public AxisServiceExporter getServiceExporter() {
        return this.serviceExporter;
    }
}

