/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.spring.axis.proxy;

import cx.ath.kgslab.spring.axis.proxy.AxisInvocationProperties;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.axis.client.Service;
import org.springframework.aop.IntroductionInterceptor;

public class AxisInvocationInterceptor
implements IntroductionInterceptor {
    private Service service = null;
    private Class serviceInterface = null;
    private String url = null;

    public AxisInvocationInterceptor() {
    }

    public AxisInvocationInterceptor(Service service, String url, Class serviceInterface) {
        this.setService(service);
        this.setUrl(url);
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public final void setServiceInterface(Class serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        String methodname = method.getName();
        AxisInvocationProperties properties = null;
        if (invocation.getThis() instanceof AxisInvocationProperties) {
            properties = (AxisInvocationProperties)invocation.getThis();
            if ("getProperty".equals(methodname)) {
                return properties.getProperty((String)invocation.getArguments()[0]);
            }
            if ("getPropertyNames".equals(methodname)) {
                return properties.getPropertyNames();
            }
            if ("setProperty".equals(methodname)) {
                properties.setProperty((String)invocation.getArguments()[0], invocation.getArguments()[1]);
                return null;
            }
            if ("removeProperty".equals(methodname)) {
                properties.removeProperty((String)invocation.getArguments()[0]);
                return null;
            }
        }
        Call call = this.service.createCall();
        if (properties != null) {
            Iterator ite = properties.getPropertyNames();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                call.setProperty(key, properties.getProperty(key));
            }
        }
        call.setTargetEndpointAddress(this.url);
        call.setOperationName(new QName("http://soapinterop.org/", method.getName()));
        return call.invoke(invocation.getArguments());
    }

    public boolean implementsInterface(Class clazz) {
        return this.serviceInterface.equals(clazz);
    }
}

