/****************************************************************/
/*                      matrix main                             */
/*       Taiga Yonekura 2000 All Rights Reserved                */
/****************************************************************/
/* Rev:  DATE    : contents                      :name          */
/*----:----------:-------------------------------:--------------*/
/*    :2000/03/03: new                           :Taiga Yonkura */
/*    :          :                               :              */
/****************************************************************/
/*gcc -o matrix matrixmain.c vesion.c imgobj.c eventobj.c status.c select.c thinkobj.c opelationnode.c enemy.c `gtk-config --cflags` `gtk-config --libs`*/

/****************************************************************/
/*                  include file                                */
/****************************************************************/
#include <gtk/gtk.h>

#include "./inc/common.h"
#include "./inc/version.h"
#include "./inc/imgobj.h"
#include "./inc/eventobj.h"
#include "./inc/select.h"
#include "./inc/status.h"

/****************************************************************/
/* ؿ̾:quit()                                                */
/*--------------------------------------------------------------*/
/* ǽ:ץꥱνλ                              */
/*--------------------------------------------------------------*/
/*   :                                                      */
/* :                                                      */
/*----:----------:-------------------------------:--------------*/
/* Rev:  DATE    : contents                      :name          */
/*----:----------:-------------------------------:--------------*/
/*    :2000/03/03: new                           :Taiga Yonkura */
/*    :          :                               :              */
/****************************************************************/
void quit()
{
  /* ׹ͥ롼ѥ꥽γ */
  STS_releaseSRC();

  gtk_exit(0);
}
/****************************************************************/
/* ؿ̾: setMenu                                              */
/*--------------------------------------------------------------*/
/* ǽ:˥塼Сκ                                  */
/*--------------------------------------------------------------*/
/*   : ˥塼Ĥvbox                                 */
/* :                                                      */
/*----:----------:-------------------------------:--------------*/
/* Rev:  DATE    : contents                      :name          */
/*----:----------:-------------------------------:--------------*/
/*    :2000/03/03: new                           :Taiga Yonkura */
/*    :          :                               :              */
/****************************************************************/
void setMenu(GtkWidget* vbox,gpointer toplevelwin)
{
  GtkWidget *menubar;
  GtkWidget *menu;
  GtkWidget *stng_item;
  GtkWidget *sub_item;
  GtkWidget *stng_menu;

  /* ˥塼С */
  menubar = gtk_menu_bar_new();
  gtk_box_pack_start(GTK_BOX(vbox),menubar,FALSE,TRUE,0);
  gtk_widget_show(menubar);

  /*****************/
  /*  GAME MENU    */
  /*****************/
  stng_menu=gtk_menu_new();

  /* GAME˥塼˥ƥ(Single Game)ɲ */
  sub_item = gtk_menu_item_new_with_label("Single Game");
  gtk_menu_append(GTK_MENU(stng_menu), sub_item);
  gtk_signal_connect(GTK_OBJECT(sub_item), "activate",
		     GTK_SIGNAL_FUNC(SEL_ShowSelct), 
		     NULL);
  gtk_widget_show(sub_item);

  /* GAME˥塼˥ƥ(Vs Game)ɲ */
  sub_item = gtk_menu_item_new_with_label("Vs Game");
  gtk_menu_append(GTK_MENU(stng_menu), sub_item);
  gtk_signal_connect(GTK_OBJECT(sub_item), "activate",
		     GTK_SIGNAL_FUNC(EVT_selectVSmode), 
		     NULL);
  gtk_widget_show(sub_item);
 
  /* GAME˥塼˥ƥ(Quit)ɲ */
  sub_item = gtk_menu_item_new_with_label("Quit");
  gtk_menu_append(GTK_MENU(stng_menu), sub_item);
  gtk_signal_connect(GTK_OBJECT(sub_item), "activate",
		     GTK_SIGNAL_FUNC(quit), 
		     NULL);
  gtk_widget_show(sub_item);

  /* */
  sub_item = gtk_menu_item_new_with_label("Game");

  gtk_widget_show(sub_item);

  /* Game˥塼ƥGame˥塼򤯤äĤ */
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(sub_item), stng_menu);

  /* ˥塼СGame˥塼ƥ򤯤äĤ */
  gtk_menu_bar_append(GTK_MENU_BAR(menubar), sub_item);

  /*****************/
  /*  AboutMENU    */
  /*****************/
  stng_menu=gtk_menu_new();
#if 0
  /* About˥塼˥ƥ(Ranking)ɲ */
  sub_item = gtk_menu_item_new_with_label("Ranking");
  gtk_menu_append(GTK_MENU(stng_menu), sub_item);
  gtk_signal_connect(GTK_OBJECT(sub_item), "activate",
		     GTK_SIGNAL_FUNC(ShowRanking), 
		     NULL);
  gtk_widget_show(sub_item);
#endif  
  /* About˥塼˥ƥ(ShowVersion)ɲ */
  sub_item = gtk_menu_item_new_with_label("Version");
  gtk_menu_append(GTK_MENU(stng_menu), sub_item);
  gtk_signal_connect(GTK_OBJECT(sub_item), "activate",
		     GTK_SIGNAL_FUNC(ShowVersion), 
		     toplevelwin);
  gtk_widget_show(sub_item);

  /* */
  sub_item = gtk_menu_item_new_with_label("About");

  gtk_widget_show(sub_item);

  /* Game˥塼ƥGame˥塼򤯤äĤ */
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(sub_item), stng_menu);

  /* ˥塼СGame˥塼ƥ򤯤äĤ */
  gtk_menu_bar_append(GTK_MENU_BAR(menubar), sub_item);

}

/****************************************************************/
/* ؿ̾:  main                                                */
/*--------------------------------------------------------------*/
/* ǽ:ᥤ롼                                      */
/*--------------------------------------------------------------*/
/*   :                                                      */
/* :                                                      */
/*----:----------:-------------------------------:--------------*/
/* Rev:  DATE    : contents                      :name          */
/*----:----------:-------------------------------:--------------*/
/*    :2000/03/03: new                           :Taiga Yonkura */
/*    :          :                               :              */
/****************************************************************/
int main(int argc, char *argv[])
{
  GtkWidget *window;
  GtkWidget *drawing_area;
  GtkWidget *vbox;

  /*     */
  gtk_set_locale();
  gtk_init(&argc, &argv);

  /*  ȥåץ٥륦ɥκ  */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  /*  ɥΥꥵػ     */
  gtk_window_set_policy(GTK_WINDOW(window),FALSE,FALSE,TRUE);

  vbox = gtk_vbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  gtk_widget_show(vbox);

  gtk_signal_connect_object(GTK_OBJECT(window), "destroy",
		     GTK_SIGNAL_FUNC(quit),NULL);

  /* ˥塼С */
  setMenu(vbox,window);

  /* ΰκ */
  drawing_area = gtk_drawing_area_new();
  gtk_drawing_area_size(GTK_DRAWING_AREA(drawing_area),SCREENW,SCREENH);
  gtk_box_pack_start(GTK_BOX(vbox),drawing_area,TRUE,TRUE,0);
  /*SetDrawingBack(drawing_area);*/
  gtk_widget_show(drawing_area);

  /* طʤϥɥ뤹륷ʥ */
  gtk_signal_connect(GTK_OBJECT(drawing_area), "expose_event",
		     GTK_SIGNAL_FUNC(EVT_expose),NULL);
  gtk_signal_connect(GTK_OBJECT(drawing_area), "configure_event",
		     GTK_SIGNAL_FUNC(EVT_configure),NULL);
  gtk_signal_connect_object(GTK_OBJECT(drawing_area), "button_press_event",
		     GTK_SIGNAL_FUNC(EVT_ClickMouse),NULL);


  /* 񤫤ʤȥå٥Ƚʤ */
  gtk_widget_set_events(drawing_area,
			GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK);

  /* ᥤ󥦥ɥɽ */
  gtk_widget_show(window);

  /* λ */
  gtk_timeout_add(100, EVT_repaint,drawing_area);

  /* ơν */
  STS_initStatus();

  /* ɤ߹ */
  IMG_loadimg(window);

  /***************************/
  /* ᥤ롼          */ 
  /***************************/
  gtk_main();

  return;
  
}



