/*
  Copyright (C) 2000-2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//#include <gtk/gtk.h>
#include "common.h"


/*
 *  Get next action pointer
 *  ptr : target search list pointer
 *  x   : next action block location
 *  y   : next action block location
 *
 *  ret : next action pointer
 *
 */
MtrxLinkNode *ope_GetNextNode(MtrxLinkNode *ptr,gint x,gint y)
{
  gint i;
  MtrxLinkNode *nextnode;

  for(i = 0;i < BLOCK_NUM_X;i++){
    nextnode = (MtrxLinkNode *)ptr->nextnode[i];
    if(nextnode != NULL){
      if((nextnode->valueobj.posx == x) && (nextnode->valueobj.posy == y)){
	// match !!
	return nextnode;
      }
    }
  }

  return NULL;
}

/*
  free value tree
 */
void OPE_FreeNode(MtrxLinkNode *node)
{

  gint index;
  MtrxLinkNode *nextNode;

  if(node == NULL){
    return;
  }

  /*
   *  search end point
   */

  for(index=0;index < BLOCK_NUM_X;index++){
    nextNode = (MtrxLinkNode *)(node->nextnode[index]);

    /*
     * this is not  end point
     */
    OPE_FreeNode(nextNode); // check next node
  }

  // free memory
  free((MtrxLinkNode *)node);
  node = NULL;

}

/*
 * delete target action
 */
void OPE_DeleteTop(MtrxLinkNode **firstp,gint x,gint y)
{
  MtrxLinkNode *next;
  gint i;

  if(*firstp != NULL){
    next = ope_GetNextNode(*firstp,x,y);
  } else {
    return;
  }

  if(next != NULL){
    /* free memory  */
    for(i = 0;i < BLOCK_NUM_X ;i++){
      if(next != (MtrxLinkNode *)(*firstp)->nextnode[i]){
	// free node wihtout next node
	OPE_FreeNode((MtrxLinkNode *)(*firstp)->nextnode[i]);
      }
    }
    // update top pointer
    *firstp = next;

  }
}






