/*
  Copyright (C) 2004  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef ACHIEVEMENT_H
#define ACHIEVEMENT_H

#include <qstring.h>
#include <qfile.h>

#define LEVEL_MAX 3

class CAchievement
{

 public:
  CAchievement(QString scoreFile);
  void RegistReslut(int level, unsigned int win, unsigned int lost );
  bool SaveReslut();
  bool Get(int level, unsigned int* win, unsigned int* lost );
  bool DownLoad();
  void Win(int level);
  void Lost(int level);


 private:

  bool OpenDataFile(QFile *pFile);
  void Save(QFile *pFile);
  int  Load(QFile *pFile);
  void Init();

  QString m_scoreFile;
  unsigned int m_result[LEVEL_MAX][2];// 0:win 1:lost
  int m_version;


};



#endif
