/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef GAMEWIDGET_H
#define GAMEWIDGET_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qthread.h>

#include "button.h"
#include "enemy.h"
#include "imageLoader.h"
#include "selecter.h"
#include "achievement.h"

class CGameWidget : public QWidget//,public QThread
{
    Q_OBJECT

public:
    CGameWidget(QWidget *parent, const char *name = 0, WFlags f = 0);
    ~CGameWidget();

private:
    CButton *m_vsbtn,*m_singlebtn;
    CButton *m_yesbtn, *m_nobtn;
    QTimer *m_timer;
    QPixmap *m_pixmap;
    QPixmap m_bug[2];
    CAchievement *m_pAchieve;
    bool bdipLogo;

    
    
    char m_thinking; //1 now thinking
   
    QPixmap m_bootlogoImg;
    QPixmap m_titleImg[2];// title image
    QPixmap m_mode[2];    // modeButton
    QPixmap m_blockImg[2];
    QPixmap m_slectImg[2];//yes or no
    QPixmap m_retryImg;   //retry
    QPixmap m_backImg;    //backgroung image
    QPixmap m_thinkImg;
    QPixmap m_message[5];
    QPixmap m_attackImg[2]; //0:player1 1:player2

    CEnemy  *m_enemy[ENEMY_COUNT];
    CEnemy  *m_selectedEnemy;
    CSelecter *m_selecter;

public slots:
    void timerTick(void);

protected:
    void paintEvent(QPaintEvent *event);
    void resizeEvent(QResizeEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void run();

private:
    void paint(void);
    void drawTitle(QPainter *paint);
    void setTitle(QPainter *paint);
    void drawDetail(QPainter *paintm,int substs);
    void drawPlayField(QPainter *paint);
    void clickMatrix(int x,int y);
    void drawAllBlock(QPainter *paint);
    void initEnemy(CImageLoader *pimgLoader);
    void DrawBootLogo( QPainter *paint, int width, int height );
};

#endif


