#!/bin/sh

if [ "$1" = "sl700" ]; then
    ln -v -f -s config/config-sl700.h config.h
    ln -v -f -s config/config.mk-sl700 config.mk
    cp desktop/qmatrix-sl700.desktop desktop/qmatrix.desktop
elif [ "$1" = "sl700-us" ]; then
    ln -v -f -s config/config-sl700-us.h config.h
    ln -v -f -s config/config.mk-sl700-us config.mk
    cp desktop/qmatrix-sl700.desktop desktop/qmatrix.desktop
elif [ "$1" = "sl300" ]; then
    ln -v -f -s config/config-sl300.h config.h
    ln -v -f -s config/config.mk-sl300 config.mk
    cp desktop/qmatrix-sl300.desktop desktop/qmatrix.desktop
elif [ "$1" = "sl300-us" ]; then
    ln -v -f -s config/config-sl300-us.h config.h
    ln -v -f -s config/config.mk-sl300-us config.mk
    cp desktop/qmatrix-sl300.desktop desktop/qmatrix.desktop
else
    echo "usage: $0 sl700 | sl300 | sl700-us | sl300-us    cross | native"
    exit 1
fi

if [ "$2" = "cross" ]; then
    export CROSSCOMPILE=/opt/Embedix/tools
    export QPEDIR=/opt/Qtopia/sharp
    export QTDIR=/opt/Qtopia/sharp
    export PATH=$QTDIR/bin:$QPEDIR/bin:$CROSSCOMPILE/bin:$PATH
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-sharp-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
elif [ "$2" = "native" ]; then
    export CROSSCOMPILE=
    export QPEDIR=/opt/Qtopia
    export QTDIR=/opt/Qtopia
    export PATH=$QTDIR/bin:$QPEDIR/bin:$PATH:/opt/Embedix/tools/bin
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-x86-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
else
    echo "usage: $0 sl700 | sl300 | sl700-us | sl300-us    cross | native"
    exit 1
fi

TMPDIR=qmatrix_1.0.0

make -C tools
make -C images clean
make -C images

tmake -o Makefile qmatrix.pro
make

mkdir ${TMPDIR}
cd ${TMPDIR}
mkdir -p opt/QtPalmtop/apps/Games
mkdir -p opt/QtPalmtop/bin
mkdir -p opt/QtPalmtop/pics
mkdir -p opt/QtPalmtop/help/html
mkdir -p CONTROL
cp ../desktop/qmatrix.desktop opt/QtPalmtop/apps/Games
cp ../qmatrix opt/QtPalmtop/bin
cp ../desktop/qmatrix.png opt/QtPalmtop/pics
cp ../desktop/qmatrix.html opt/QtPalmtop/help/html
cp ../desktop/qmatrix.control CONTROL/control
cp ../desktop/qmatrix.prerm CONTROL/prerm

cd ..
ipkg-build ${TMPDIR}
rm -rf ${TMPDIR}

