/*
  Copyright (C) 2000-2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "common.h"
#include "status.h"


static gchar tmp_mtrxpat[(BLOCK_NUM_X + 2)*(BLOCK_NUM_Y + 2)];

void THK_FreeNode(MtrxLinkNode *);


gint thk_ValueOfPoint(gchar *mtrxpat,gint x,gint y)
{
  gint index_x;	        
  gint index_y;	        
  gchar type;	        
  gint seqcnt[8];       
  gint emptycnt[8];     
  gboolean emptyblk[8]; 
  gint value[4];        
  gint valuetmp;
  gint i;
  gint xmax = BLOCK_NUM_X + 2;
  gint ymax = BLOCK_NUM_Y + 2;

  type = mtrxpat[x + y *(BLOCK_NUM_X + 2)];
  /******************/
  /**/
  /******************/
  seqcnt[0]   = 0;
  emptycnt[0] = 0;
  emptyblk[0] = FALSE;
		
  for(index_y = y-1;index_y >= 0;index_y--){
    if(mtrxpat[x + index_y * (BLOCK_NUM_X + 2)] == type){
      /* */
      if(emptycnt[0] != 0){
	/*  */
	emptyblk[0] = TRUE;
	break;
      }
      seqcnt[0]++;
    } else if(mtrxpat[x + index_y * (BLOCK_NUM_X + 2)] == 0){
      /*  */
      emptycnt[0]++;
      break;         /* */
    } else {
      /**/
      break;
    }
  }
		
  /*******************/
  /* */
  /*******************/
  seqcnt[1]   = 0;
  emptycnt[1] = 0;
  emptyblk[1] = FALSE;
		
  for(index_x = x-1,index_y = y-1;((index_x >= 0) && (index_y >= 0));index_x--,index_y--){
    if(mtrxpat[index_x + index_y * (BLOCK_NUM_X + 2)] == type){
      /**/
      if(emptycnt[1] != 0){
	/**/
	emptyblk[1] = TRUE;
	break;
      }
      seqcnt[1]++;
    } else if(mtrxpat[index_x + index_y * (BLOCK_NUM_X + 2)] == 0){
      /**/
      emptycnt[1]++;
    } else {
      /**/
      break;
    }
  }
		
  /********************/
  /*  */
  /********************/
  seqcnt[2]   = 0;
  emptycnt[2] = 0;
  emptyblk[2] = FALSE;
		
  for(index_x = x+1,index_y = y-1;((index_x < xmax) && (index_y >= 0));index_x++,index_y--){
    if(mtrxpat[index_x + index_y * (BLOCK_NUM_X + 2)] == type){
      /**/
      if(emptycnt[2] != 0){
	/**/
	emptyblk[2] = TRUE;
	break;
      }
      seqcnt[2]++;
    } else if(mtrxpat[index_x + index_y * (BLOCK_NUM_X + 2)] == 0){
      /**/
      emptycnt[2]++;
    } else {
      /**/
      break;
    }
  }
		
  /*****************/
  /* */
  /*****************/
  seqcnt[3]   = 0;
  emptycnt[3] = 0;
  emptyblk[3] = FALSE;
		
  for(index_x = x-1;index_x >= 0;index_x--){
    if(mtrxpat[index_x + y * (BLOCK_NUM_X + 2)] == type){
      /**/
      if(emptycnt[3] != 0){
	/**/
	emptyblk[3] = TRUE;
	break;
      }
      seqcnt[3]++;
    } else if(mtrxpat[index_x + y * (BLOCK_NUM_X + 2)] == 0){
      /**/
      emptycnt[3]++;
    } else {
      /**/
      break;
    }
  }

  /******************/
  /* */
  /******************/
  seqcnt[4]   = 0;
  emptycnt[4] = 0;
  emptyblk[4] = FALSE;

  for(index_x = x+1;index_x < xmax;index_x++){
    if(mtrxpat[index_x + y * (BLOCK_NUM_X + 2)] == type){
      /**/
      if(emptycnt[4] != 0){
	/**/
	emptyblk[4] = TRUE;
	break;
      }
      seqcnt[4]++;
    } else if(mtrxpat[index_x + y * (BLOCK_NUM_X + 2)] == 0){
      /**/
      emptycnt[4]++;
    } else {
      /**/
      break;
    }
  }
		
  /*****************/
  /**/
  /*****************/
  seqcnt[5]   = 0;
  emptycnt[5] = 0;
  emptyblk[5] = FALSE;
		
  for(index_y = y+1;index_y < ymax;index_y++){
    if(mtrxpat[x + index_y * (BLOCK_NUM_X + 2)]== type){
      /**/
      if(emptycnt[5] != 0){
	/**/
	emptyblk[5] = TRUE;
	break;
      }
      seqcnt[5]++;
    } else if(mtrxpat[x + index_y * (BLOCK_NUM_X + 2)] == 0){
      /**/
      emptycnt[5]++;
    } else {
      /**/
      break;
    }
  }
		
  /*******************/
  /* */
  /*******************/
  seqcnt[6]   = 0;
  emptycnt[6] = 0;
  emptyblk[6] = FALSE;
		
  for(index_x = x-1,index_y = y+1;
      ((index_x >= 0) && (index_y < ymax));index_x--,index_y++){
    if(mtrxpat[index_x + index_y * (BLOCK_NUM_X + 2)] == type){
      /**/
      if(emptycnt[6] != 0){
	/**/
	emptyblk[6] = TRUE;
	break;
      }
      seqcnt[6]++;
    } else if(mtrxpat[index_x + y * (BLOCK_NUM_X + 2)] == 0){
      /**/
      emptycnt[6]++;
    } else {
      /**/
      break;
    }
  }
		
  /********************/
  /*  */
  /********************/
  seqcnt[7]   = 0;
  emptycnt[7] = 0;
  emptyblk[7] = FALSE;
		
  for(index_x = x+1,index_y = y+1;
      ((index_x < xmax) && (index_y < ymax));index_x++,index_y++){
    if(mtrxpat[index_x + index_y * (BLOCK_NUM_X + 2)] == type){
      /**/
      if(emptycnt[7] != 0){
	/**/
	emptyblk[7] = TRUE;
	break;
      }
      seqcnt[7]++;
    } else if(mtrxpat[index_x + index_y *(BLOCK_NUM_X + 2)] == 0){
      /**/
      emptycnt[7]++;
    } else {
      /**/
      break;
    }
  }
		
  /**************/
  /* */
  /**************/
		
  /*************/
  /**/
  /*************/
  valuetmp = seqcnt[3] + seqcnt[4];
  if(valuetmp >= 3){
    /*****************************/
    /**/
    /*****************************/
    valuetmp = VALUE_MAX;
  } else if(valuetmp == 2){
    /******************/
    /*  */
    /******************/
    valuetmp++;
    if(emptycnt[3] != 0 && emptycnt[4] != 0){
      /**/
      valuetmp *= 100;
    } else if(emptycnt[3] != 0){
      valuetmp *= 50;
      /**/
    } else if(emptycnt[4] != 0){
      /**/
      valuetmp *= 50;
				
    } else {
      /**/
      valuetmp = 0;
    }
			
  } else if(valuetmp == 1) {
    /******************/
    /**/
    /*****************/
    valuetmp++;
    if(emptycnt[3] != 0 && emptycnt[4] != 0){
      /**/
      valuetmp *= 5;
    } else if(emptycnt[3] != 0){
      /**/
      valuetmp *= 2;
    } else if(emptycnt[4] != 0){
      /**/
      valuetmp *= 2;
				
    } else {
      /**/
      valuetmp = 0;
    }
  } else if(valuetmp == 0) {
    /*****************/
    /**/
    /*****************/
    if(emptycnt[3] != 0 && emptycnt[4] != 0){
      /**/
      valuetmp = 2;
    } else if(emptycnt[3] != 0){
      /**/
      valuetmp = 1;
    } else if(emptycnt[4] != 0){
      /**/
      valuetmp = 1;
				
    } else {
      /**/
      valuetmp = 0;
				
    }
  }
  value[0] = valuetmp;
		
  /*************/
  /**/
  /*************/
  valuetmp = seqcnt[0] + seqcnt[5];
  if(valuetmp >= 3){
    /****************************/
    /**/
    /****************************/
    valuetmp = VALUE_MAX;
  } else if(valuetmp == 2){
    /*****************/
    /**/
    /*****************/
    valuetmp++;
    if(emptycnt[0] != 0 && emptycnt[5] != 0){
      /**/
      valuetmp *= 100;
    } else if(emptycnt[0] != 0){
      valuetmp *= 50;
      /**/
    } else if(emptycnt[5] != 0){
      /**/
      valuetmp *= 50;
    } else {
      /**/
      valuetmp = 0;
    }
			
  } else if(valuetmp == 1) {
    /******************/
    /**/
    /******************/
    valuetmp++;
    if(emptycnt[0] != 0 && emptycnt[5] != 0){
      /**/
      valuetmp *= 5;
    } else if(emptycnt[0] != 0){
      /**/
      valuetmp *= 2;
    } else if(emptycnt[5] != 0){
      /**/
      valuetmp *= 2;
    } else {
      /**/
      valuetmp = 0;
    }
  } else if(valuetmp == 0) {
    /*****************/
    /* */
    /*****************/
    if(emptycnt[0] != 0 && emptycnt[5] != 0){
      /**/
      valuetmp = 2;
    } else if(emptycnt[0] != 0){
      /**/
      valuetmp = 1;
    } else if(emptycnt[5] != 0){
      /**/
      valuetmp = 1;
    } else {
      /**/
      valuetmp = 0;
    }
  }
  value[1] = valuetmp;

  /****************/
  /**/
  /****************/
  valuetmp = seqcnt[1] + seqcnt[7];
  if(valuetmp >= 3){
    /*****************************/
    /**/
    /*****************************/
    valuetmp = VALUE_MAX;
  } else if(valuetmp == 2){
    /******************/
    /* */
    /******************/
    valuetmp++;
    if(emptycnt[1] != 0 && emptycnt[7] != 0){
      /**/
      valuetmp *= 100;
    } else if(emptycnt[1] != 0){
      valuetmp *= 50;
      /**/
    } else if(emptycnt[7] != 0){
      /**/
      valuetmp *= 50;
    } else {
      /**/
      valuetmp = 0;
    }
			
  } else if(valuetmp == 1) {
    /******************/
    /* */
    /******************/
    valuetmp++;
    if(emptycnt[1] != 0 && emptycnt[7] != 0){
      /**/
      valuetmp *= 5;
    } else if(emptycnt[1] != 0){
      /**/
      valuetmp *= 2;
    } else if(emptycnt[7] != 0){
      /**/
      valuetmp *= 2;
    } else {
      /**/
      valuetmp = 0;
    }
  } else if(valuetmp == 0) {
    /******************/
    /*  */
    /******************/
    if(emptycnt[1] != 0 && emptycnt[7] != 0){
      /**/
      valuetmp = 2;
    } else if(emptycnt[1] != 0){
      /**/
      valuetmp = 1;
    } else if(emptycnt[7] != 0){
      /**/
      valuetmp = 1;
    } else {
      /**/
      valuetmp = 0;
    }
  }
  value[2] = valuetmp;
		
  /****************/
  /**/
  /****************/
  valuetmp = seqcnt[2] + seqcnt[6];
  if(valuetmp >= 3){
    /*****************************/
    /* */
    /*****************************/
    valuetmp = VALUE_MAX;
  } else if(valuetmp == 2){
    /******************/
    /* */
    /******************/
    valuetmp++;
    if(emptycnt[2] != 0 && emptycnt[6] != 0){
      /**/
      valuetmp *= 100;
    } else if(emptycnt[2] != 0){
      valuetmp *= 50;
      /**/
    } else if(emptycnt[6] != 0){
      /**/
      valuetmp *= 50;
    } else {
      /**/
      valuetmp = 0;
    }
  
  } else if(valuetmp == 1) {
    /******************/
    /*  */
    /******************/
    valuetmp++;
    if(emptycnt[2] != 0 && emptycnt[6] != 0){
      /**/
      valuetmp *= 5;
    } else if(emptycnt[2] != 0){
      /**/
      valuetmp *= 2;
    } else if(emptycnt[6] != 0){
      /**/
      valuetmp *= 2;
    } else {
      /**/
      valuetmp = 0;
    }
  } else if(valuetmp == 0) {
    /******************/
    /* */
    /******************/
    if(emptycnt[2] != 0 && emptycnt[6] != 0){
      /**/
      valuetmp = 2;
    } else if(emptycnt[2] != 0){
      /**/
      valuetmp = 1;
    } else if(emptycnt[6] != 0){
      /**/
      valuetmp = 1;
    } else {
      /**/
      valuetmp = 0;
    }
  }
  value[3] = valuetmp;
		
  valuetmp = 0;
  for(i=0;i<4;i++){
    if(value[i] == VALUE_MAX){
      valuetmp = VALUE_MAX;
      break;
    } else {
      valuetmp += value[i];
    }
  }
		
  return valuetmp;
}

gint thk_setValue(gchar *mtrxpat)
{
  gint x_index,y_index;
  gint P1value;
  gint P2value;
  gint c_value;
		
  gint xmax = BLOCK_NUM_X + 2;
  gint ymax = BLOCK_NUM_Y + 2;

  P1value = 0;
  P2value = 0;
		
  for(y_index = 0;y_index < ymax;y_index++){
    for(x_index = 0;x_index < xmax;x_index++){
      /**/
      if((mtrxpat[x_index+y_index*(BLOCK_NUM_X + 2)] == (gchar)BLOCK_STOPPER)  
	 || (mtrxpat[x_index+y_index*(BLOCK_NUM_X + 2)] == (gchar)BLOCK_NONE)){
	continue;
      }
      /**************************/
      /* */
      /**************************/
      if(mtrxpat[x_index+y_index*(BLOCK_NUM_X + 2)] == FIRST_PLAYER){
	/* */
	c_value = thk_ValueOfPoint(mtrxpat,x_index,y_index);
	if(c_value != VALUE_MAX){
	  P1value += c_value;
	} else {
	  /**/
	  P1value = c_value;
	  return P1value;/**/
	}
					
      } else {
	/**/
	c_value = thk_ValueOfPoint(mtrxpat,x_index,y_index);
	if(c_value != VALUE_MAX){
	  P2value += c_value;
	} else {
	  /**/
	  P2value = c_value;
	  return -1*P2value;/**/
	}
      }
				
    }
  }

  return P1value - P2value; /**/

} 

void thk_mtrxValue(MtrxValue *ptrval, gchar *data)
{
  gint setx,sety;

  setx = ptrval->posx;
  sety = ptrval->posy;

  data[setx + sety * (BLOCK_NUM_X + 2)] = ptrval->player;

  /*  */
  ptrval->value = thk_setValue(data);

  /*  */
  data[setx + sety * (BLOCK_NUM_X + 2)] = BLOCK_NONE;
}

MtrxLinkNode* thk_GetTotalValueObj(MtrxLinkNode* ptr)
{
  gint i;
  MtrxLinkNode* pnode;

  for(i=0;i < BLOCK_NUM_X;i++){
    pnode = (MtrxLinkNode*)(ptr->nextnode[i]);
    if((pnode != NULL) && (ptr->totalval == pnode->totalval)){
      return pnode;
    }
  }

  return NULL;
}

MtrxLinkNode* THK_CreateNextNode(gint x,gint y,gint type)
{
  MtrxLinkNode *ptr;
  gint i;

  ptr = (MtrxLinkNode *)malloc(sizeof(MtrxLinkNode));
  ptr->valueobj.posx   = x;
  ptr->valueobj.posy   = y;
  ptr->valueobj.player = type;

  for(i = 0;i < BLOCK_NUM_X;i++){
    ptr->nextnode[i] = NULL;
  }

  

  return ptr;
}

gint thk_GetMaxTotalValue(MtrxLinkNode *node)
{
  gint i;
  gint max = -VALUE_MAX;
  gboolean setflg = FALSE;
  MtrxLinkNode *nextnode;
		
  for(i=0;i< BLOCK_NUM_X;i++){
    nextnode = (MtrxLinkNode *)(node->nextnode[i]);
    if(nextnode != NULL){
      if(setflg == FALSE){
	max = nextnode->totalval;
	setflg = TRUE;
      } else {
	if(max < nextnode->totalval){
	  max = nextnode->totalval;
	}
      }
    }
  }
		
  return max;
}

gint thk_GetMinTotalValue(MtrxLinkNode *node)
{
  gint i;
  gint min = VALUE_MAX;
  gboolean setflg = FALSE;
  MtrxLinkNode *nextnode;
		
  for(i=0;i< BLOCK_NUM_X;i++){

    nextnode = (MtrxLinkNode *)(node->nextnode[i]);
    if(nextnode != NULL){
      if(setflg == FALSE){
	min = nextnode->totalval;
	setflg = TRUE;
      } else {
	if(min > nextnode->totalval){
	  min = nextnode->totalval;
	}
      }
    }
  }
  return min;
}

gint thk_GetMaxValue(MtrxLinkNode *node)
{
  gint i;
  gint max = -VALUE_MAX;
  gboolean setflg = FALSE;
  MtrxLinkNode *nextnode;
		
  for(i=0;i< BLOCK_NUM_X;i++){

    nextnode = (MtrxLinkNode *)(node->nextnode[i]);
    if(nextnode != NULL){
      if(setflg == FALSE){
	max = nextnode->valueobj.value;
	setflg = TRUE;
      } else {
	if(max < nextnode->valueobj.value){
	  max = nextnode->valueobj.value;
	}
      }
    }
  }
		
  return max;
}

gint thk_GetMinValue(MtrxLinkNode *node)
{
  gint i;
  gint min = VALUE_MAX;
  gboolean setflg = FALSE;
  MtrxLinkNode *nextnode;
		
  for(i=0;i< BLOCK_NUM_X;i++){

    nextnode = (MtrxLinkNode *)(node->nextnode[i]);
    if(nextnode != NULL){
      if(setflg == FALSE){
	min = nextnode->valueobj.value;
	setflg = TRUE;
      } else {
	if(min > nextnode->valueobj.value){
	  min = nextnode->valueobj.value;
	}
      }
    }
  }
		
  return min;
}

gboolean THK_CheckValue(MtrxValue *ptrvalue)
{
  gint val;

  /****************/
  /*  */
  /****************/
  val = ptrvalue->value;

  if((val == VALUE_MAX) || (val == -VALUE_MAX)) {
    /************/
    /* */
    /************/
    return TRUE;
  } else {
    /************/
    /*  */
    /************/
    return FALSE;
  }  
}

gboolean THK_CheckSetable(gint x,gint y,gchar *mtrix)
{

  if((x >= 0) && (x < BLOCK_NUM_X + 2) && (y >= 0) && (y < BLOCK_NUM_Y + 2)){
    if( (mtrix[x+(y+1)*(BLOCK_NUM_X+2)] != BLOCK_NONE) 
	&& (mtrix[x+y*(BLOCK_NUM_X+2)] == BLOCK_NONE) ){
      /**************************************************/
      /*  */
      /**************************************************/
      return TRUE;
      }
  }
		
  return FALSE;
}

void THK_SetStatusMatrix(gint x,gint y,gint status,gchar *mtrxpat)
{
  mtrxpat[x + y * (BLOCK_NUM_X + 2)] = status;
}

void thk_SetMtrxValue(MtrxLinkNode *node,gint depth)
{
  gint x,y; 
  gint type;
  gint index;
  gint setindex;
  MtrxLinkNode *nextNode;

  if(THK_CheckValue(&(node->valueobj))){
    /************/
    /**/
    /************/

    /* */
    node->totalval = node->valueobj.value;
    return;
  }

  if(depth == 0){
    /******************/
    /*  */
    /******************/
    return;
  }

  /************/
  /* */
  /************/
  type = node->valueobj.player;
  THK_SetStatusMatrix(node->valueobj.posx,node->valueobj.posy,type,tmp_mtrxpat);

  /**************/
  /*  */
  /**************/

  for(index=0;index < BLOCK_NUM_X;index++){
    nextNode = (MtrxLinkNode *)(node->nextnode[index]);
    if(nextNode != NULL){

      /****************/
      /*  */
      /****************/
      if((nextNode->totalval == VALUE_MAX) 
	 || (nextNode->totalval == -VALUE_MAX)) {
	/************/
	/*  */
	/************/
	continue;
      } else {
	/************/
	/*  */
	/************/
	thk_SetMtrxValue(nextNode,depth - 1); /*  */
      }

    } else {

      /****************/
      /*     */
      /****************/
      setindex = 0;

      for(x = 1;x <BLOCK_NUM_X  + 1;x++){
	for(y = BLOCK_NUM_Y;y > 0;y--){

	  if(THK_CheckSetable(x,y,tmp_mtrxpat) == TRUE){
	    /************/
	    /* */
	    /************/
	    if(type ==  FIRST_PLAYER){
	      /********/
	      /* */
	      /********/
	      /*  */
	      node->nextnode[setindex] = 
		(void *)THK_CreateNextNode(x,y,SECOND_PLAYER);
	      
	    } else {
	      /********/
	      /**/
	      /********/
	      /*  */
	      node->nextnode[setindex] = 
		(void *)THK_CreateNextNode(x,y,FIRST_PLAYER);
	    }
	    nextNode = (MtrxLinkNode *)(node->nextnode[setindex]);
	    /* */
	    thk_mtrxValue((MtrxValue *)&(nextNode->valueobj),tmp_mtrxpat);

	    /* */
	    thk_SetMtrxValue(nextNode,depth - 1);
	    setindex++;

	  } else {

	    /************/
	    /* */
	    /************/
	    if(tmp_mtrxpat[x+(y+1)*(BLOCK_NUM_X + 2)] == BLOCK_NONE){
	      /**/
	      break;
	    }
	  }

	}
      }

      break;


    }
  }
  /****************/
  /* */
  /****************/
  THK_SetStatusMatrix(node->valueobj.posx,node->valueobj.posy,BLOCK_NONE,tmp_mtrxpat);

  /****************/
  /*  */
  /****************/
  if(depth == 1){
    /********************/
    /*  */
    /********************/
    if(type == FIRST_PLAYER) {/**/
      /**/
      node->totalval = thk_GetMinValue(node);
    } else {
      /**/
      node->totalval = thk_GetMaxValue(node);
    }
  } else {
    if(type == FIRST_PLAYER) {/*蹶*/
      /**/
      node->totalval = thk_GetMinTotalValue(node);
    } else {
      /**/
      node->totalval = thk_GetMaxTotalValue(node);
    }
  }

}

void THK_NextAttack(MtrxLinkNode *ptr)
{
  MtrxLinkNode *next;
  gint x,y;

  /* */
  next = thk_GetTotalValueObj(ptr);

  /*  */
  x = next->valueobj.posx;
  y = next->valueobj.posy;
  OPE_DeleteTop(STS_GetStartPoint(),x,y);

  /* */
  STS_Setmatrixtbl(x,y,SECOND_PLAYER);

  /* */



  
}


void THK_ClearMtrxTbl(gchar *matrix)
{
  gint i,j;
		
  /**/
  for(i=0;i < BLOCK_NUM_X + 2;++i){
    for(j=0;j < BLOCK_NUM_Y + 2;++j){
      *(matrix + i +  j *(BLOCK_NUM_X + 2))  = BLOCK_NONE;
    }
  }
		
  /**/
  for(i=0;i < BLOCK_NUM_X + 2;++i){
    *(matrix + i + 0)  = BLOCK_STOPPER;
    *(matrix + i + (BLOCK_NUM_Y + 2 - 1)*(BLOCK_NUM_X + 2)) = BLOCK_STOPPER;
  }

  for(i=0;i < BLOCK_NUM_Y + 2;++i){
    *(matrix + 0 +  i * (BLOCK_NUM_X + 2)) = BLOCK_STOPPER;
    *(matrix + (BLOCK_NUM_X + 2 - 1) + i * (BLOCK_NUM_X + 2))  = BLOCK_STOPPER;
  }
}

void THK_CopyMtrxTbl(gchar *src,gchar *dis)
{
  gint i;

  for(i = 0;i < (BLOCK_NUM_X + 2)*(BLOCK_NUM_Y + 2);i++){
    *(dis + i)=*(src + i);
  }

}

gboolean THK_valuVSmode(gchar *mtrxpat)
{
  gint value;

  value = thk_setValue(mtrxpat);

  if((value == VALUE_MAX ) || (value == -VALUE_MAX)){
    return TRUE;
  } else {
    return FALSE;
  }

}

/*
  thinking main
 */
void THK_main(gint x,gint y,gint strong)
{

  MtrxLinkNode** startptr;

  startptr = STS_GetStartPoint();

  if(*startptr == NULL){
    /* this code runs at first time */

    /* create node  */
    *startptr = THK_CreateNextNode(x,y,FIRST_PLAYER);

    /* copy phase */
    THK_CopyMtrxTbl(matrixtbl,tmp_mtrxpat);

    /* begin look-ahead phase */
    thk_SetMtrxValue(*startptr,strong);//EMY_getStrong());

    /*    pthread_create(&th1,NULL,(void *)thk_SetMtrxValue(*startptr,4),NULL);
     */
    /*THK_NextAttack(*startptr); */
    
  } else {
    OPE_DeleteTop(STS_GetStartPoint(),x,y);
 
    /* copy phase */
    THK_CopyMtrxTbl(matrixtbl,tmp_mtrxpat);

     /* begin look-ahead phase */
    thk_SetMtrxValue(*startptr,strong);//EMY_getStrong());   
    
    /*THK_NextAttack(*startptr);  */  
  }

} 



