/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef DISPLAY_H
#define DISPLAY_H

#include <qpixmap.h>
#include <qpainter.h>
#include <string.h>
#include "StringDisplay.h"
#include "ScoreMng.h"

class CDisplay
{

 public:

  CStringDisplay m_StringDisplay;

  CDisplay();
  void setBackGround( QPainter *paint, int width, int height );
  void setTitle( QPainter *paint );
  void drawFishList( QPainter *paint, int total, int catched );
  void drawClearTime( QPainter *paint, int hour, int min, int sec );
  void DrawHiScoreList( QPainter *paint, CScoreMng *scrMng, QString &Title);
  void DrawBootLogo( QPainter *paint, int width, int height );
  QPixmap* GetNetImages();
  QPixmap* GetFishImages( int type );
  QPixmap* GetStartBtnImages();
  int GetFishHeight( int type );
  int GetFishWidth( int type );

 private:

    QPixmap m_fishBMP0[8];	  // fish image
    QPixmap m_fishBMP1[8];	  // fish image
    QPixmap m_titleBMP;           // title image
    QPixmap m_titleNumBMP; 
    QPixmap m_netBMP[3];
    QPixmap m_logoBMP;
    QPixmap m_fishListBMP[2];
    
    QPixmap m_numBMP[10];  // Number Images
    QPixmap m_timeBMP[3];  // h,m,s (time string)

    QPixmap m_startBtnBMP;
    QPixmap m_BootLogBMP;

    void drawNumber(QPainter *paint, int num, int startx, int starty);

};
#endif
