/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "HiScoreReg.h"
#include "Application.h"
#include "refresh.h"
#include "HiScoreRegConfig.h"

#define BLINK_INTERVAL 500 //500 msec
#define STRING_LIST    "ABCDEFGHIJKLMNOPQRSTUVWXYZ"

#define INITLINE(x,y) {x=STRLIST_POSX;y=STRLIST_POSY;}
#define NEWLINE(x,y) {x=STRLIST_POSX;y += STRLIST_HEIGHT;}
#define NEXT(x,y) {x+=CHARSPACE;}

CHiScoreReg::CHiScoreReg( CStringDisplay* pStrDisp )
{

  int x,y;
  uint i;
  uint size;

  m_inputedCnt = 0;

  QString List = STRING_LIST;
  size = List.length ();

  INITLINE(x,y);
  for( i = 0; i < size ; i++){
    if( i && !(i % 6) ) NEWLINE(x,y);
    QChar ch = List[i];
    m_pStrBtn[i] = new CStringBtn( pStrDisp->GetImage(ch), ch, x, y);
    NEXT(x,y);
    //    if( i && !(i % 6) ) NEWLINE(x,y);
  }


  // ARROW Btn
  m_pStrBtn[i++] = new CStringBtn( pStrDisp->GetImage(CStringDisplay::MOV_LEFT), QChar(' '), 
				 ARROWLEFT_BTN_POSX, ARROWLEFT_BTN_POSY, ARROWLEFT_BTN);
  m_pStrBtn[i++] = new CStringBtn( pStrDisp->GetImage(CStringDisplay::MOV_RIGHT), QChar(' '), 
				 ARROWLEFT_BTN_POSX + 30,  ARROWLEFT_BTN_POSY, ARROWRIGHT_BTN);
  // DELETE Btn
  m_pStrBtn[i++] = new CStringBtn( pStrDisp->GetImage(CStringDisplay::DELETE), QChar(' '), 
				 ARROWLEFT_BTN_POSX + 60,  ARROWLEFT_BTN_POSY, DEL_BTN);  

  // OK Btn
  m_pStrBtn[i++] = new CStringBtn( pStrDisp->GetImage(QChar('O')), QChar('O'), 
				 OK_BUTTON_POSX, OK_BUTTON_POSY, OK_BTN );
  m_pStrBtn[i++] = new CStringBtn( pStrDisp->GetImage(QChar('K')), QChar('K'), 
				 OK_BUTTON_POSX + 24, OK_BUTTON_POSY, OK_BTN);

  m_pStrBtn[i] = NULL; //Stopper

  m_pBrankImg = pStrDisp->GetImage(QChar('-'));
  for( i = 0; i < HINAME_MAX ; i++){
    m_pName[i] = new CStringBtn( m_pBrankImg, QChar('-'), 
				 NAME_FILED_POSX + i*24, NAME_FILED_POSY);
  }

  m_blinkInterval = GET_TIME(BLINK_INTERVAL);
  m_blink = TRUE;
}

void CHiScoreReg::DrawRegistView(QPainter *paint, int width, int height)
{

  QString title = "INPUT YOUR NAME";
  QColor black(0, 0, 0);
  int i;

  m_blinkInterval--;

  paint->fillRect(0, 0, width, height, black);
  
  STRINGDISPLAY().Draw( paint, &title, TITLE_POSX, TITLE_POSY );

  for( i = 0; i < HINAME_MAX ; i++){

    if( i != m_inputedCnt ){
      m_pName[i]->draw(paint);
    } else {

      if(!m_blinkInterval){

	if(m_blink){
	  m_blink = false;
	} else {
	  m_blink = true;
	}

      }

      if(m_blink){
	m_pName[i]->draw(paint);
      }

    }

  }

  for( i = 0; m_pStrBtn[i] ; i++){
    m_pStrBtn[i]->draw(paint);
  }

  // reset blink interval time
  if( !m_blinkInterval ){
    m_blinkInterval = GET_TIME(BLINK_INTERVAL);
  }
}
//
//
//
bool CHiScoreReg::OnTap( int x, int y )
{

  int i;
  bool ret = FALSE;

  for( i = 0; m_pStrBtn[i] ; i++){

    if( m_pStrBtn[i]->isOn( x, y ) ){

      switch( m_pStrBtn[i]->GetType() ){

      case SINGLECH_BTN:
	if( m_inputedCnt < HINAME_MAX ){
	  m_pName[m_inputedCnt]->SetImage( m_pStrBtn[i]->GetImage() );
	  if( m_inputedCnt < HINAME_MAX - 1 ){
	    m_inputedCnt++;
	  }
	}
	break;

      case DEL_BTN:
	if( m_inputedCnt < HINAME_MAX ){
	  m_pName[m_inputedCnt]->SetImage( m_pBrankImg );
	}
	break;

      case OK_BTN:
	ret = TRUE;
	m_inputedCnt = 0;
	break;

      case ARROWLEFT_BTN:
	if( m_inputedCnt > 0 )  m_inputedCnt--;
	break;

      case ARROWRIGHT_BTN:
	if( m_inputedCnt < HINAME_MAX - 1 )  m_inputedCnt++;
	break;

      }

    }

  }
  
  return ret;
  
}
//
//
//
QString CHiScoreReg::GetName()
{

  QString name;
  int i;

  for( i = 0; i < HINAME_MAX ; i++){

    QChar ch = STRINGDISPLAY().GetImageCh( m_pName[i]->GetImage() );
    if( ch != '-' ){
      name += ch;
    } else {
      // brank
      name += ' ';
    }
  }

  clearNameFiled();

  return name;

}
void CHiScoreReg::clearNameFiled()
{
  int i;

  for( i = 0; i < HINAME_MAX ; i++){
    m_pName[i]->SetImage( STRINGDISPLAY().GetImage(QChar('-')) );
  }

}
