/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef CFISH_H
#define CFISH_H

#include "sprite.h"
#include "HitArea.h"
#include "areaSize.h"

#define WITHIN_NET_FISH 0
#define CROSS_NET_FISH  1
#define OUT_OF_NET_FISH 2

class CFish : public CSprite  
{
public:

	enum LEVEL{
	  HARD,
	  EASY
	};

	enum AREA_TYPE{
	  LEFT,
	  RIGHT,
	  UP,
	  DOWN,
	  LEFT_UP,
	  LEFT_DOWN,
	  RIGHT_UP,
	  RIGHT_DOWN
	};

	CFish(int,int,int,int,PIXMAP *);
	void moveslow();
	void movefast();
	void initSpeed( CFish::LEVEL level );
	void set_real_y(void);
	void draw(PAINTER* painter);
	void CFishInit(int,int,int,int,PIXMAP *);
	virtual ~CFish();
	int checkUpperNet( CHitArea *Area );
	void setHitArea(CFish::AREA_TYPE type, CHitArea *Area[],int AreaCount);
	void setImageList(PIXMAP *);

private:
	void set_real_x(void );
	void set_real_x_slow(void );
	void set_real_y_slow();
	void randset();
	void setWay(int);
	int makerad();
	bool cheak_y(int y);
	bool cheak_x(int x);
	int m_xsize,m_ysize;                 // character size
	int m_screenHeight,m_screenWidth;  // screen size
	double m_radTable[24];              // rad table
	double m_rad;	                   // selected rad table
	double m_speed;	                   // speed
	int    m_way;	                   // way
	int m_x0,m_y0;	                   // inital positon
	double m_real_x,m_real_y;              // internal position
	PIXMAP *m_fishBMP;                   // fish BITMAP
	CHitArea *m_HitArea[8];
	int m_HitAreaCount[8];



};

#endif 
