/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://jankeyapp-z.sourceforge.jp/

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef CFIELD_H
#define CFIELD_H


#include "Cell.h"
#include "config.h"

class CField
{
 public:
  CField();
  void initFiled();
  void initNextBlock();
  void setRandomBlock();
  bool hashFunc(int x, int y, int* hashval);
  void setNextBlock();
  bool upBlock();
  int checkLine(int index, int parent);
  void DeletSameBlk();
  void CancelSameBlk();
  int checkClkBomb(int index);
  void downBlkLine(int index);
  void downBlk();
  void slideBlk();
  void setBlockTypeNum(int num);
  CCell& getNextBlock(int index);
  CCell& getFieldBlock(int index);
  int getNextBlockCount();
  int getFiledBlockWidth();
  int getFiledBlockHeight();
  bool IsBrokenAll();
  bool IsBomb( int index );

 private:

  CCell m_field[FIELD_NUM_X*FIELD_NUM_Y];
  CCell m_nextBlock[FIELD_NUM_X];
  bool m_fildLock;
  int m_blockTypeNum;

  bool IsEmptyRow(int row);
  void slideRight(int row);
  void slideLeft(int row);
};


#endif

