/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://jankeyapp-z.sourceforge.jp/

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "Status.h"

#define NORMAL 2000
#define HARD   1000
#define SUPERHARD  800
#define SUPERHARD2 600
#define SUPERHARD3 300

CStatus::CStatus()
{
  initStatus();
}
void CStatus::initStatus()
{
  m_status = STSIDLE;
  m_score  = 0;
  m_level  = 0;
  m_upcnt = 1;
}
char CStatus::getStatus()
{
  return m_status;
}
void CStatus::setStatus(char sts)
{
  m_status = sts;
}
int CStatus::getScore()
{
  return m_score;
}
void CStatus::setScore(int score)
{
  m_score += score;
}

//
//
//
int CStatus::checkLevel(CField *pCFiled)
{

  int ret = NORMAL;

  switch(m_level){

  case 0:
    if(m_score > 1000){
      m_level = 1;
      pCFiled->setBlockTypeNum(3);
      ret = HARD;
      m_upcnt = 1;
    }
    break;

  case 1:
    if(m_score > 2000){
      m_level = 2;
      pCFiled->setBlockTypeNum(3);
      ret = SUPERHARD;
      m_upcnt = 1;
    }
    break;

  case 2:
    if(m_score > 3000){
      m_level = 3;
      pCFiled->setBlockTypeNum(3);                  
      ret = SUPERHARD3;
      m_upcnt = 1;
    }
    break;

  case 3:
    if(m_score > 4000){
      m_level = 4;
      pCFiled->setBlockTypeNum(5);
      ret = NORMAL;
      m_upcnt = 1;
    }
    break;

  case 4:
    if(m_score > 5000){
      m_level = 5;
      pCFiled->setBlockTypeNum(5);
      ret = HARD;
      m_upcnt = 1;
    }
    break;


  case 5:
    if(m_score > 6000){
      m_level = 6;
      pCFiled->setBlockTypeNum(5);
      ret = SUPERHARD2;
      m_upcnt = 1;
    }
    break;

  case 6:
    if(m_score > 7000){
      m_level = 7;
      pCFiled->setBlockTypeNum(5);
      ret = SUPERHARD3;
      m_upcnt = 1;
    }
    break;

  case 7:
    if(m_score > 8000){
      m_level = 8;
      pCFiled->setBlockTypeNum(3);
      ret = NORMAL;
      m_upcnt = 2;
    }
    break;

  case 8:
    if(m_score > 9000){
      m_level = 9;
      pCFiled->setBlockTypeNum(3);
      ret = HARD;
      m_upcnt = 2;
    }
    break;

  case 9:
    if(m_score > 10000){
      m_level = 8;
      pCFiled->setBlockTypeNum(3);
      ret = HARD;
      m_upcnt = 3;
    }
    break;

  }

  return ret;
  
}
int CStatus::getHiScore()
{
  return m_hiscore;
}
void CStatus::setHiScore(int score)
{

  if(m_hiscore < score){
    m_hiscore = score;
  }
  
}
void CStatus::clearHiScore()
{
  m_hiscore = 0;
}
int CStatus::getUpcount()
{
  return m_upcnt;
}
