/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://jankeyapp-z.sourceforge.jp/

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef GAMEWIDGET_H
#define GAMEWIDGET_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qthread.h>

#include "Status.h"
#include "Field.h"
#include "Display.h"
#include "ScoreMng.h"
#include "HiScoreReg.h"

//#include "StringDisplay.h"

class CGameWidget : public QWidget
{
    Q_OBJECT

public:
    CGameWidget(QWidget *parent, const char *name = 0, WFlags f = 0);
    ~CGameWidget();
    static CDisplay *m_pDisplay;

protected:
    void paintEvent(QPaintEvent *event);
    void resizeEvent(QResizeEvent *event);
    void mousePressEvent(QMouseEvent *event);

private:
    QTimer *m_pTimer;
    QPixmap *m_pixmap;

    CStatus *m_pStatus;
    CField  *m_pField;
    //    CDisplay *m_pDisplay;
    CScoreMng *m_pScoreMng;
    CHiScoreReg *m_pHiScoreReg;

    int m_gamemode;
    int m_lockTime;
    int m_DispStayTime;
    int m_bootDispTime;

    //    CStringDisplay *m_pStrDisp;

    void paint(void);
    void OnTapUnderPlay(QMouseEvent *event);
    void OnTapTitle(QMouseEvent *event);

public slots:
    void timerTick(void);

};

#endif


