#!/bin/sh

VERSION=1.0.0

if [ "$1" = "sl700" ]; then
    ln -v -f -s config/config-sl700.h config.h
    ln -v -f -s config/config.mk-sl700 config.mk
    ln -v -f -s HiScoreRegConfig-sl700.h HiScoreRegConfig.h
    PACKAGE_FILE=qtap_${VERSION}-sl700_arm.ipk
elif [ "$1" = "sl300" ]; then
    ln -v -f -s config/config-sl300.h config.h
    ln -v -f -s config/config.mk-sl300 config.mk
    ln -v -f -s HiScoreRegConfig-sl300.h HiScoreRegConfig.h
    PACKAGE_FILE=qtap_${VERSION}-sl300_arm.ipk
else
    echo "usage: $0 sl700 | sl300 cross | native"
    exit 1
fi

if [ "$2" = "cross" ]; then
    export CROSSCOMPILE=/opt/Embedix/tools
    export QPEDIR=/opt/Qtopia/sharp
    export QTDIR=/opt/Qtopia/sharp
    export PATH=$QTDIR/bin:$QPEDIR/bin:$CROSSCOMPILE/bin:$PATH
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-sharp-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
elif [ "$2" = "native" ]; then
    export CROSSCOMPILE=
    export QPEDIR=/opt/Qtopia
    export QTDIR=/opt/Qtopia
    export PATH=$QTDIR/bin:$QPEDIR/bin:$PATH:/opt/Embedix/tools/bin
    export TMAKEPATH=/opt/Qtopia/tmake/lib/qws/linux-x86-g++/
    export LD_LIBRARY_PATH=$QTDIR/lib:$LD_LIBRARY_PATH
else
    echo "usage: $0 cross | native"
    exit 1
fi

TMPDIR=qtap_1.0.0
APPNAME=qtap

make -C tools
make -C images

tmake -o Makefile qtap.pro
make

mkdir ${TMPDIR}
cd ${TMPDIR}
mkdir -p opt/QtPalmtop/apps/Games
mkdir -p opt/QtPalmtop/bin
mkdir -p opt/QtPalmtop/pics
mkdir -p opt/QtPalmtop/help/html
mkdir -p CONTROL
mkdir -p opt/QtPalmtop/sounds/qtap

cp ../desktop/${APPNAME}.desktop opt/QtPalmtop/apps/Games
cp ../${APPNAME} opt/QtPalmtop/bin
cp ../desktop/${APPNAME}.png opt/QtPalmtop/pics
lv -Ou8cp ../desktop/${APPNAME}.html > opt/QtPalmtop/help/html/${APPNAME}.html
cp ../desktop/${APPNAME}.html opt/QtPalmtop/help/html
cp ../desktop/${APPNAME}.control CONTROL/control
cp ../desktop/${APPNAME}.prerm CONTROL/prerm

cp ../sounds/qtap01.wav opt/QtPalmtop/sounds/qtap


cd ..
ipkg-build ${TMPDIR}
mv qtap_1.0.0_arm.ipk ${PACKAGE_FILE}
echo created package ${PACKAGE_FILE}
rm -rf ${TMPDIR}

