/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://jankeyapp-z.sourceforge.jp/

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef DISPLAY_H
#define DISPLAY_H

#include <qpainter.h>
#include <qpixmap.h>

#include "Status.h"
#include "Field.h"
#include "StringDisplay.h"
#include "ScoreMng.h"

class CDisplay
{

  //static CStringDisplay StringDisplay;

 public:
  CDisplay();

  CStringDisplay StringDisplay;

  void drawNextBlock(QPainter *paint, CField &field);
  void drawField(QPainter *paint, CField &field);
  void drawScore(QPainter *paint, int score);
  void drawHiScore(QPainter *paint, int score);
  void DrawHiScoreList(QPainter *paint, CScoreMng *scrMng, int width, int height );
  void displayOff();
  void displayOn();
  void setNextBlkWaitTime(int time);
  void drawPlayField(QPainter *paint, CField *field, CStatus *pStatus,int width, int height);
  void drawTitle( QPainter *paint , int width, int height );
  void drawBackGround( QPainter *paint, int width, int height );
  void DrawBootLogo( QPainter *paint, int width, int height );

 private:
  bool m_dispON;
  QPixmap m_titleBMP[3]; // Title Images
  QPixmap m_blockBMP[8]; // Block Images
  QPixmap m_bombBMP[2];  // Bomb Images
  //QPixmap m_msgBMP[1];   // Message Images
  QPixmap m_numBMP[10];  // Number Images 
  QPixmap m_BootLogBMP;
  QPixmap m_mmBMP;
  QPixmap m_backBMP;

  int m_WaitTime;
  int m_nextBlkWait;

  void drawGemeOver( QPainter *paint );
  void drawNumber(QPainter *paint, int num, int startx, int starty);
  void drawBlockFrame(QPainter *paint);
  void DrawBuilding( QPainter *paint);
  int  Center_x(QString *pStr );
  int  Center_x(QPixmap* pImg);
  void drawScoreBackGround( QPainter *paint, int width, int height );
};
#endif
