/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://jankeyapp-z.sourceforge.jp/

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//
// Register File Format
//--------------------------------------------------
// Version    (4byte)     1
//--------------------------------------------------
// MAGIC CODE (4byte)     unregist:0  registed:98
//--------------------------------------------------
// unregisted boot counter (4byte)
//--------------------------------------------------

#include "Register.h"

#define KEY_VER 1
#define REGIST_MAGIC 5826
#define UNREGIST_BOOT_COUNT 10
#define PASSWORD "QTYNMO"
#define KEY_FILENAME ".qtapkey"

CRegister::CRegister()
{
  m_registed = false;
  m_maxBooting = true;

  if( !QFile::exists( KEY_FILENAME ) ){
      return;
  }

  QFile file( KEY_FILENAME );

  load(&file);
  
}
void CRegister::load(QFile *pFile)
{


  int version;
  int magic;
  int count;

  pFile->open( IO_Raw | IO_ReadWrite);

  // read version
  if(pFile->readBlock ( (char *)&version, sizeof(int)) == -1){
    pFile->close();
    return;
  }

  // read magic code
  if(pFile->readBlock ( (char *)&magic, sizeof(int)) == -1){
    pFile->close();
    return;
  }

  // read boot counter
  if(pFile->readBlock ( (char *)&count, sizeof(int)) == -1){
    pFile->close();
    return;
  }

  //----------------
  // check readdata
  //----------------
  if( version != KEY_VER ){
    pFile->close();
    return;
  }

  if( magic == REGIST_MAGIC ){
    m_registed = true;
    pFile->close();
    return;
  }  

  if( count >= UNREGIST_BOOT_COUNT ){
    // already registed.
    m_maxBooting = true;
    pFile->close();
    return;
  } else {
    // add counter
    count++;
    pFile->at( sizeof(int)*2 );
    pFile->writeBlock ( (char *)&count, sizeof( count ) ); 
  } 


  pFile->close();

}
//
// return value true is registed
//
bool CRegister::IsRegisted()
{
  return m_registed;
}
//
// return limit booting count
//
bool CRegister::IsOverBooting()
{
  return m_maxBooting;
}
//
// check password and regist
//
bool CRegister::RegistKey( QString passwd )
{
  QString key(PASSWORD);
  bool ret;

  if( !QFile::exists( KEY_FILENAME ) ){
      return false;
  }

  if( key == passwd ){
    ret = true;
    
  } else {
    ret = false;
  }

  return ret;
}
//
// regist key
//
bool CRegister::regist()
{
  QFile File( KEY_FILENAME );

  int version = KEY_VER;
  int magic = REGIST_MAGIC;
  int count = 0;

  File.open( IO_Raw | IO_ReadWrite);
  File.writeBlock ( (char *)&version, sizeof( version ) ); 
  File.writeBlock ( (char *)&magic, sizeof( magic ) ); 
  File.writeBlock ( (char *)&count, sizeof( count ) );
  File.close();

  return true;

}
