/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://jankeyapp-z.sourceforge.jp/

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifdef DESKTOP
#include <qapplication.h>
#else
#include <qpe/qpeapplication.h>
#endif

#include <qtimer.h>
#include <qmessagebox.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qkeycode.h>

#ifdef SOUND_ENABLE
#include <qpe/resource.h>
#include <qsound.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>

#include "gameWidget.h"
#include "qtap.h"
#include "refresh.h"

#define UNDER_BOOT      0
#define TITLE           1
#define DISPHISCORE     2
#define PLAYFIELD       3
#define REGISTSCORE     4
 
#define LOCK_TIME 2000 //2sec
#define TITLE_DISPTIME  10000 
#define HILIST_DISPTIME 5000

#define HISCORE_DATA_FNAME ".qtapscore.dat"

CDisplay* CGameWidget::m_pDisplay;

CGameWidget::CGameWidget(QWidget *parent, const char *name, WFlags f) :
    QWidget(parent, name, f)
{

  m_pTimer = new QTimer(this);
  m_gamemode = UNDER_BOOT;
  m_pixmap = 0;
  m_bootDispTime = GET_TIME( LOCK_TIME );
  m_DispStayTime = GET_TIME( TITLE_DISPTIME );

  m_pStatus = new CStatus();
  m_pField = new CField();
  m_pDisplay = new CDisplay();
  m_pHiScoreReg = NULL;

  m_pScoreMng = new CScoreMng( HISCORE_DATA_FNAME );
  m_pScoreMng->DownLoadHiScore();
  m_pHiScoreReg = new CHiScoreReg( &STRINGDISPLAY() );

  connect(m_pTimer, SIGNAL(timeout()), this, SLOT(timerTick()));

  m_pTimer->start(REFRESH_INTERVAL);

}
CGameWidget::~CGameWidget()
{
  delete m_pStatus;
  delete m_pField;
  delete m_pDisplay;
  delete m_pHiScoreReg;
  delete m_pScoreMng;
}
void CGameWidget::timerTick(void)
{

  if(!m_bootDispTime--){
    m_gamemode = TITLE;
  } else if( m_gamemode == TITLE || m_gamemode == DISPHISCORE ){
    
    if( !(--m_DispStayTime) ){

       if( m_gamemode == TITLE ){
	 m_gamemode = DISPHISCORE;
	 m_DispStayTime = GET_TIME( HILIST_DISPTIME );
       } else {
	 m_gamemode = TITLE;
	 m_DispStayTime = GET_TIME( TITLE_DISPTIME );
       }
    }
  }

  repaint(false);

}

void CGameWidget::paintEvent(QPaintEvent *event)
{
  paint();
}
void CGameWidget::resizeEvent(QResizeEvent *event)
{
    QWidget::resizeEvent(event);
    if (!m_pixmap || event->size() != event->oldSize()) {
	if (m_pixmap) {
	    delete m_pixmap;
	}
	m_pixmap = new QPixmap(event->size().width(), event->size().height());
    }
}
void CGameWidget::paint(void)
{

    QPainter painter_pixmap(m_pixmap);
    QPainter painter_widget(this);

    if(m_gamemode == UNDER_BOOT){
      // Draw Boot Logo
      m_pDisplay->DrawBootLogo(&painter_pixmap, width(), height() );
      painter_pixmap.flush();
      painter_widget.drawPixmap(0, 0, *m_pixmap);
    }

    switch(m_gamemode){

    case TITLE:
      //display title
      m_pDisplay->drawTitle( &painter_pixmap, width(), height() );
      break;

    case DISPHISCORE:
      m_pDisplay->DrawHiScoreList( &painter_pixmap, m_pScoreMng, width(), height() );
      break;

    case PLAYFIELD:
      m_pDisplay->drawPlayField( &painter_pixmap, m_pField, m_pStatus, 
			      width() , height());
      m_pDisplay->drawScore( &painter_pixmap, m_pStatus->getScore() );
      m_pDisplay->drawHiScore( &painter_pixmap, m_pScoreMng->GetHiScore(1) );
      if( m_pStatus->getStatus() == STSGAMEOVER){
	m_lockTime--;
      }
      break;

    case REGISTSCORE:
      if(m_pHiScoreReg) 
	m_pHiScoreReg->DrawRegistView( &painter_pixmap, width(), height());
      break;

    }

    painter_pixmap.flush();
    painter_widget.drawPixmap(0, 0, *m_pixmap);

}
void CGameWidget::mousePressEvent(QMouseEvent *event)
{

  int x,y;
  int score;

  x = event->x();
  y = event->y();

  if( m_pStatus->getStatus() == STSGAMEOVER &&  m_lockTime < 0 ) {
    //GAME OVER
    score = m_pStatus->getScore();
    if( m_pScoreMng->IsRankIn(score) ){
      m_gamemode = REGISTSCORE;
    } else {
      m_gamemode = TITLE;
      m_DispStayTime = GET_TIME( HILIST_DISPTIME );
    }

    m_pStatus->setStatus(STSIDLE);

    return;
  }
	
  //if not input stattus retrun
  if( m_pStatus->getStatus() != STSIDLE) return;

  switch(m_gamemode){

  case TITLE:
    OnTapTitle(event);
    break;

  case DISPHISCORE:
    m_gamemode = TITLE;
    m_DispStayTime = GET_TIME( HILIST_DISPTIME ); 
    break;

  case PLAYFIELD:
    OnTapUnderPlay(event);
    break;

  case REGISTSCORE:
    if( m_pHiScoreReg->OnTap( x, y ) ){
      // go to title
      score = m_pStatus->getScore();
      m_pScoreMng->RegistHiScore( m_pHiScoreReg->GetName(), score);
      m_pScoreMng->SaveHiScore();
      m_gamemode = TITLE;
      m_DispStayTime = GET_TIME( HILIST_DISPTIME );
    }
    break;

  }
  
}
void CGameWidget::OnTapUnderPlay(QMouseEvent *event)
{
  int index;
  int sameBlk = 0;
  int time;
	
  if( m_pField->hashFunc( event->x(), event->y(), &index ) ){

    sameBlk = m_pField->checkLine( index, index);
		
    if( ( sameBlk && (sameBlk > 1) ) ||  m_pField->IsBomb(index) ){
      m_pStatus->setScore( sameBlk * sameBlk );
      time = m_pStatus->checkLevel(m_pField);
      if(time){
	m_pDisplay->setNextBlkWaitTime( time / REFRESH_INTERVAL );
      }
      m_pStatus->setStatus(STSDELETEBLK);

#ifdef SOUND_ENABLE
      // play broken sound

#ifdef HOST_DEBUG
      QSound::play( QString("sounds/qtap01.wav") );
#else
      QSound::play( Resource::findSound( QString("qtap/") + "qtap01" ) );
#endif

#endif

      
    } else {
      m_pField->CancelSameBlk();
    }

  } else {

    return;

  }

}
void CGameWidget::OnTapTitle(QMouseEvent *event)
{

  int time;

  m_lockTime = GET_TIME(LOCK_TIME);
  m_pField->initFiled();
  m_pStatus->initStatus();
  m_pDisplay->displayOn();

  time = m_pStatus->checkLevel(m_pField);
  if(time){
    m_pDisplay->setNextBlkWaitTime( time / REFRESH_INTERVAL );
  }

  m_gamemode = PLAYFIELD;

}
