/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "GameoverView.h"
#include "StringTable.h"

CGameOverView::CGameOverView(CEnemy* pEnemy, int b, int w)
{
  m_pEnemy = pEnemy;
  m_black  = b;
  m_white  = w;

  if( m_black > m_white ){
    m_resultStr = STRING_UTF8( ID_STRING_1103 );
    m_pEnemy->lost();
  } else if( m_black < m_white ){
    m_resultStr = STRING_UTF8( ID_STRING_1102 );
    m_pEnemy->win();
  } else {
    m_resultStr = STRING_UTF8( ID_STRING_1101 );
    m_pEnemy->draw();
  }
}
void CGameOverView::draw(QPainter *paint, int width, int height )
{
  QPixmap* pImg;
  QColor white( 255, 255, 255 );
  QColor black(0,0,0);
  QString str;

  paint->fillRect( 0, 0, width, height, black );

  pImg = m_pEnemy->getNormalImage();

  paint->drawPixmap( Center_x(pImg), RESULTENEMY_POS_Y, *pImg );

  paint->setPen(white);
  str = STRING_UTF8( ID_STRING_1100 );
  paint->drawText( Center_x(&str), RESULT_POS_Y, str );

  paint->drawText( Center_x(&m_resultStr), STATE_POS_Y, m_resultStr );

  str = STRING_UTF8( ID_STRING_1104 ) + QString(" ");
  str +=QString::number( m_black );
  paint->drawText( Center_x(&str), YOURSCORE_POS_Y,str );

  str = m_pEnemy->getName()+ QString(" ");
  str +=QString::number( m_white );
  paint->drawText( Center_x(&str), ENEMYSCORE_POS_Y,str);
  
  str = STRING_UTF8( ID_STRING_1105 );
  paint->drawText( Center_x(&str), RETURN_POS_Y, str );

}
int CGameOverView::click( int x, int y )
{
  return 0;
}
