/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include "GameoverVsView.h"
#include "StringTable.h"

CGameOverVsView::CGameOverVsView(QPixmap* pBlack, QPixmap* pWhite, QPixmap* pBack,
				 int bcnt, int wcnt)
{

  m_pBlackImg = pBlack;
  m_pWhiteImg = pWhite;
  m_pBack = pBack;
  m_black  = bcnt;
  m_white  = wcnt;
  m_pWinImg = 0;

  if( m_black > m_white ){
    m_resultStr = STRING_UTF8( ID_STRING_1110 );
    m_pWinImg = pBlack;
  } else if( m_black < m_white ){
    m_resultStr = STRING_UTF8( ID_STRING_1111 );
    m_pWinImg = pWhite;
  } else {
    m_resultStr = STRING_UTF8( ID_STRING_1101 );
  }
}
void CGameOverVsView::draw(QPainter *paint, int width, int height )
{
  QPixmap* pImg;
  QColor white( 255, 255, 255 );
  QColor black(0,0,0);
  QString str;

  paint->fillRect( 0, 0, width, height, black );

  if(m_pWinImg){
    paint->drawPixmap( Center_x(m_pBack), RESULTENEMY_POS_Y, *m_pBack );
    paint->drawPixmap( Center_x(m_pWinImg), RESULTENEMY_POS_Y, *m_pWinImg );
  }

  paint->setPen(white);
  str = STRING_UTF8( ID_STRING_1100 );
  paint->drawText( Center_x(&str), RESULT_POS_Y, str );

  paint->drawText( Center_x(&m_resultStr), STATE_POS_Y, m_resultStr );

  str = STRING_UTF8( ID_STRING_1112 );
  str +=QString::number( m_black ) + QString(" ");
  paint->drawText( Center_x(&str), YOURSCORE_POS_Y, str );
  str = STRING_UTF8( ID_STRING_1113 );
  str +=QString::number( m_white ) + QString(" ");
  paint->drawText( Center_x(&str), ENEMYSCORE_POS_Y, str );
  
  str = STRING_UTF8( ID_STRING_1105 );
  paint->drawText( Center_x(&str), RETURN_POS_Y,str );

}
int CGameOverVsView::click( int x, int y )
{
  return 0;
}
