/*
 * Copyright (C) 2002 Robert Ernst <robert.ernst@linux-solutions.at>
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See COPYING for GPL licensing information.
 *
 */

#ifndef __PLAYFIELD_HEADER__
#define __PLAYFIELD_HEADER__

#include <qwidget.h>
#include "PlayTile.h"
#include "SpriteCollection.h"
#include "Engine.h"
#include "Game.h"
#include "Move.h"
#include "config.h"
#include "button.h"
#include "CustomView.h"
#include "enemyMng.h"
#include "ConfigInfo.h"

#define rows 8
#define cols 8
#define tilesize TILE_SIZE
#define empty 0
#define blue  1
#define red 24


class PlayField
{

public:
    PlayField(QWidget *pParent,QWidget *pMainWidget);
    ~PlayField();

public:
    /*
    static const int rows = 8;
    static const int cols = 8;
    static const int tilesize = 30;
    static const int empty = 0;
    static const int blue = 1;
    static const int red = 24;
    */
    enum State {
      //      UNDER_BOOT,
      //BOOT,
      //TITLE,
      PLAYER_MOVE,
      PLAYER_TURN,
      COMPUTER_MOVE,
      COMPUTER_TURN,
      HINT,
      GAME_OVER,
    };
    enum ViewState {
      UNDER_BOOT,
      BOOT,
      TITLE,
      ENEMY_SELECT,
      UNDERPLAY,
      RESULT,
    };
private:
    QWidget *m_pParent;
    QWidget *m_pMainWidget;
    SpriteCollection *m_sprites;
    PlayTile *m_tile[rows * cols];
    bool m_game_running;
    enum State m_state;
    enum ViewState m_viewState;
    int m_strength;
    int m_animations;
    bool m_computerBegins;
    Game game;
    Engine engine;
    CCustomView *m_pViews;
    CEnemyMng    m_EnemyMng;
    CConfigInfo   m_Config;
    bool m_bDrawSkip;
    bool m_bVsMode;

public:
    void start(bool bReset = true ,int state = 0 );
    void back(void);
    void hint(void);
    void tileClicked(int id);
    void tileClickedVs(int id);
    void updateAnimations(int animations);

    void drawTile( QPainter *pPainter );
    void Click(int x, int y);
    void draw(QPainter *pPainter);
    void quit();
    
private:
    void computerMove(void);
    void drawTile(int col, int row, int state);
    void turnTilesRow(int row, int col, int dy, int dx);
    void turnTiles(Move &move);
    void updateBoard(void);
    void gameOver(void);
    int PlayerColor(void);
    int ComputerColor(void);
    void getChipCount( int *black, int *white );
    void ChangeView( ViewState view );
    QString getStateStr();
    bool loadLog();
    void load();
    void DrawFiled( QPainter *pPainter );

};

#endif // __PLAYFIELD_HEADER__

