/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef ENEMY_H
#define ENEMY_H

#include <qpixmap.h>

#define CENEMY_IMGCNT 1

class CEnemy
{

 public:
  CEnemy(int strong,QString name);
  int getStrong();
  QString getName();
  void setImages(QPixmap *img[]);
  void setImages(QPixmap *img);
  void setHiddenImages(QPixmap *img);
  QPixmap *getNormalImage();
  QPixmap *getImage();
  void setResult(unsigned int win, unsigned int lost, unsigned int draw);
  void getResult(unsigned int* win, unsigned int* lost, unsigned int* draw);
  void win();
  void lost();
  void draw();
  void setHidden( bool hidden );
  bool isHidden();

 private:
  int m_strong;
  QPixmap *m_Img[CENEMY_IMGCNT];
  QPixmap *m_phiddenImg;
  unsigned int m_result[3]; //0:win 1:lost 2:draw
  QString m_name;
  bool m_hidden;
  
};

#endif



