/*
  Copyright (C) 2005  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <qdir.h>
#include "enemyMng.h"
#include "StringTable.h"

// achievement files
#define ACHIEVEMENT_DIR    ".mreversi"
#define ACHIEVEMENT_FNAME  ".mreversi/result.dat"

CEnemyMng::CEnemyMng()
{
  initEnemy();
  initAchieve();
  m_selected = -1;
  if(isHidden()){
    m_pEnemy[0]->setHidden(true);
  } else {
    m_pEnemy[0]->setHidden(false);
  }
}
CEnemyMng::~CEnemyMng()
{
  delete m_pAchieve;
}
void CEnemyMng::initAchieve()
{
    // setup score directory
    QDir dir;
    if( !dir.exists( ACHIEVEMENT_DIR ) ){
      dir.mkdir( ACHIEVEMENT_DIR );
    }
    m_pAchieve = new CAchievement(ACHIEVEMENT_FNAME);
    if( !m_pAchieve->DownLoad() ){
      // fail download
      m_pAchieve->SaveReslut();// make file
    }

    for(int level = 0; level < ENEMY_COUNT; level++){
      unsigned int win,lost,draw;
      m_pAchieve->Get( level, &win, &lost, &draw );
      m_pEnemy[level]->setResult( win, lost, draw );
    }
}
CEnemy* CEnemyMng::GetEnemy( int type )
{
  return m_pEnemy[type];
}

int CEnemyMng::GetEnemyCount()
{
  return ENEMY_COUNT;
}
void CEnemyMng::initEnemy()
{
  //to do
  QString name = STRING_UTF8( ID_STRING_02 );
  m_pEnemy[0] = new CEnemy(4,STRING_UTF8( ID_STRING_01 ));
  m_pEnemy[0]->setImages(m_ememyImg.GetImg(0));
  m_pEnemy[0]->setHiddenImages(m_ememyImg.GetImg(5));

  m_pEnemy[1] = new CEnemy(3,name);
  m_pEnemy[1]->setImages(m_ememyImg.GetImg(1));

  m_pEnemy[2] = new CEnemy(2,STRING_UTF8( ID_STRING_03 ));
  m_pEnemy[2]->setImages(m_ememyImg.GetImg(2));

  m_pEnemy[3] = new CEnemy(1,STRING_UTF8( ID_STRING_04 ));
  m_pEnemy[3]->setImages(m_ememyImg.GetImg(3));

  m_pEnemy[4] = new CEnemy(0,STRING_UTF8( ID_STRING_05 ));
  m_pEnemy[4]->setImages(m_ememyImg.GetImg(4));

}
void CEnemyMng::SelectEnemy( int type )
{
  m_selected = type;
}
CEnemy* CEnemyMng::GetSelectedEnemy()
{
  return m_pEnemy[m_selected];
}
void CEnemyMng::SaveResult()
{

  for(int level = 0; level < ENEMY_COUNT; level++){
    unsigned int win,lost,draw;
    m_pEnemy[level]->getResult( &win, &lost, &draw );
    m_pAchieve->RegistReslut( level, win, lost, draw );
  }

  m_pAchieve->SaveReslut();

  if(isHidden()){
    m_pEnemy[0]->setHidden(true);
  } else {
    m_pEnemy[0]->setHidden(false);
  }

}
bool CEnemyMng::isHidden()
{

  bool ret = false;
  for(int level = 1; level < ENEMY_COUNT; level++){
    unsigned int win,lost,draw;
    m_pEnemy[level]->getResult( &win, &lost, &draw );
    if(!lost){
      ret = true;
      break;
    }

  }

  return ret;
}
int CEnemyMng::GetSelectEnemyType()
{
  return m_selected;
}
