/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifdef DESKTOP
#include <qapplication.h>
#else
#include <qpe/qpeapplication.h>
#endif
#include <qtimer.h>
#include <qmessagebox.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qkeycode.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "gameWidget.h"


#define REDRAW_INTERVAL 100

CGameWidget::CGameWidget(QWidget *parent, const char *name, WFlags f) :
    QWidget(parent, name, f)
{

  m_pixmap = 0;

  m_pPlayField = new PlayField( parent, this );
  //  m_pPlayField->start();

  m_RedrawTimer = new QTimer(this);
  connect(m_RedrawTimer, SIGNAL(timeout()), this, SLOT(doRedraw()));
  m_RedrawTimer->start(REDRAW_INTERVAL);

}
CGameWidget::~CGameWidget()
{

}

void CGameWidget::doRedraw(void)
{
  repaint(false);
}

void CGameWidget::paintEvent(QPaintEvent *event)
{
  paint();
}
void CGameWidget::resizeEvent(QResizeEvent *event)
{
    QWidget::resizeEvent(event);
    if (!m_pixmap || event->size() != event->oldSize()) {
	if (m_pixmap) {
	    delete m_pixmap;
	}
	m_pixmap = new QPixmap(event->size().width(), event->size().height());
    }
}
void CGameWidget::mousePressEvent(QMouseEvent *event)
{
  m_pPlayField->Click( event->x(), event->y() );
}
void CGameWidget::mouseMoveEvent(QMouseEvent *event)
{

}

void CGameWidget::mouseReleaseEvent(QMouseEvent *event)
{


}

void CGameWidget::paint(void)
{

    QPainter painter_pixmap(m_pixmap);
    QPainter painter_widget(this);

    //m_pPlayField->drawTile( &painter_pixmap );
    m_pPlayField->draw(&painter_pixmap);

    painter_pixmap.flush();
    painter_widget.drawPixmap(0, 0, *m_pixmap);
    
}
void CGameWidget::close()
{
  m_pPlayField->quit();
}
