/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#ifndef GAMEWIDGET_H
#define GAMEWIDGET_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qtimer.h>
#include "PlayField.h"

class CGameWidget : public QWidget
{
    Q_OBJECT

public:
    CGameWidget(QWidget *parent, const char *name = 0, WFlags f = 0);
    ~CGameWidget();
    void close();

private:
    QTimer  *m_RedrawTimer;
    QPixmap *m_pixmap;
    PlayField *m_pPlayField;

public slots:
    void doRedraw(void);

protected:
    void paintEvent(QPaintEvent *event);
    void resizeEvent(QResizeEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    //    void close();//Event ( QCloseEvent *e );

private:
    void paint(void);

};

#endif


