/*
  Copyright (C) 2003  Taiga Yonekura, taiga@col.hi-ho.ne.jp

  For more information about this appliation please look at:
   http://www.pat.hi-ho.ne.jp/kyonekura

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifdef DESKTOP
#include <qapplication.h>
#define QAPP QApplication
#define BASE_PATH  QString(".")
#else
#include <qpe/qpeapplication.h>
#define QAPP QPEApplication
#define BASE_PATH QPEApplication::qpeDir()
#endif

#include "MainWin.h"

#include <qtranslator.h>
#include <stdlib.h>
#define LANG_FILE QString("/mreversi.qm")

//#define BASE_PATH  QString(".")

void setupLang( QAPP *pApp,  QTranslator *pTr )
{
	
  QString lang[2];
  lang[0] = getenv("LANG");
  
  int i  = lang[0].find(".");

  if(i > 0){ 
    lang[1] = lang[0].left(i);
  }
  
  i = lang[1].find( "_" );
  if(i > 0){
    lang[1] = lang[1].left(i);
  }

  for(int i=0; i < 2; i++){

    QString path = BASE_PATH + "/i18n/" + lang[i] + LANG_FILE;
    if(pTr->load(path)){
      pApp->installTranslator(pTr);
      break;
    }
  }

}

int main(int argc, char *argv[])
{
    QAPP app(argc, argv);
    CMainWin mwin;

    QTranslator translator(0);
    setupLang(&app,&translator);

    app.setMainWidget(&mwin);
#ifndef DESKTOP
    QPEApplication::setInputMethodHint(&mwin, QPEApplication::AlwaysOff);
#else
    mwin.setMinimumSize(SCREENW,SCREENH);
    mwin.setMaximumSize(SCREENW,SCREENH);
#endif
    mwin.showMaximized();
    return app.exec();
}

