/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.dyndns.nuda.tools.regex.annotation.Regex;
import org.dyndns.nuda.tools.regex.annotation.RegexItem;
import org.dyndns.nuda.tools.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexProcessor {
    private static Logger logger = LoggerFactory.getLogger((String)"RegexProcessor");
    private static Map<String, Pattern> cache = new HashMap<String, Pattern>();

    public <T> List<T> process(String source, Class<T> cls) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (source == null) {
            logger.error("source is null");
            return resultList;
        }
        if (cls == null) {
            logger.error("process class is null");
            return resultList;
        }
        if (!cls.isAnnotationPresent(Regex.class)) {
            logger.error("process class invalid");
            return resultList;
        }
        int flg = 40;
        Regex regex = cls.getAnnotation(Regex.class);
        try {
            Pattern pattern = null;
            pattern = cache.containsKey(regex.pattern()) ? cache.get(regex.pattern()) : Pattern.compile(regex.pattern(), flg);
            Matcher matcher = pattern.matcher(source);
            List<Field> fields = ReflectUtil.getAnnotationPresentedField(cls, RegexItem.class);
            HashMap<Integer, Field> fieldMap = new HashMap<Integer, Field>();
            for (Field f : fields) {
                fieldMap.put(f.getAnnotation(RegexItem.class).groupIndex(), f);
            }
            while (matcher.find()) {
                T instance = cls.newInstance();
                for (Map.Entry entry : fieldMap.entrySet()) {
                    Field targetField = (Field)fieldMap.get(entry.getKey());
                    if (targetField == null) continue;
                    Class<?> fieldType = targetField.getType();
                    if (fieldType.equals(String.class)) {
                        targetField.set(instance, matcher.group((Integer)entry.getKey()));
                        continue;
                    }
                    if (!fieldType.equals(List.class)) continue;
                    ParameterizedType paramType = (ParameterizedType)targetField.getGenericType();
                    Type[] types = paramType.getActualTypeArguments();
                    Class componentType = (Class)types[0];
                    if (componentType.equals(String.class)) {
                        RegexItem subRegexItem = targetField.getAnnotation(RegexItem.class);
                        String subPatternStr = subRegexItem.pattern();
                        int subindex = subRegexItem.subindex();
                        if (subindex > -1 && subPatternStr != null && !subPatternStr.isEmpty()) {
                            ArrayList<String> subList = new ArrayList<String>();
                            String subSource = matcher.group((Integer)entry.getKey());
                            Pattern subPattern = Pattern.compile(subPatternStr, flg);
                            Matcher subMatcher = subPattern.matcher(subSource);
                            while (subMatcher.find()) {
                                String subResult = subMatcher.group(subindex);
                                if (subResult != null && !subResult.isEmpty()) {
                                    subList.add(subResult);
                                    continue;
                                }
                                logger.debug("matcher[" + subPatternStr + "target[" + subSource + "]" + " not exists group " + subindex);
                            }
                            targetField.set(instance, subList);
                            continue;
                        }
                        logger.debug("injector[" + componentType.getName() + "](" + targetField.getName() + ")" + " is not present RegexItem(pattern or subindex)");
                        continue;
                    }
                    if (componentType.isAnnotationPresent(Regex.class)) {
                        String subSource = matcher.group((Integer)entry.getKey());
                        Regex subRegex = componentType.getAnnotation(Regex.class);
                        logger.debug("injector[" + componentType.getName() + "]" + " subsource[" + subSource + "]" + " pattern[" + subRegex + "]");
                        List<T> subList = this.process(subSource, componentType);
                        if (subList.size() > 0) {
                            targetField.set(instance, subList);
                            continue;
                        }
                        RegexItem refSource = targetField.getAnnotation(RegexItem.class);
                        if (refSource.unmatcherRef().isEmpty()) continue;
                        String unmatcherRef = refSource.unmatcherRef();
                        try {
                            Field unmatcherRefField = cls.getDeclaredField(unmatcherRef);
                            if (!unmatcherRefField.getType().equals(String.class)) continue;
                            unmatcherRefField.set(instance, subSource);
                        }
                        catch (SecurityException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchFieldException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    logger.debug("injector[" + componentType + "] is not present Regex Annotation");
                }
                resultList.add(instance);
            }
            return resultList;
        }
        catch (PatternSyntaxException e) {
            logger.error("pattern[" + regex.pattern() + "] can't compile to java.util.regex.Pattern", (Throwable)e);
            return resultList;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return resultList;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return resultList;
        }
    }
}

