/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.util;

import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.LoggerFactory;

public class ReflectUtil {
    public static final int[] PRIME = new int[]{31, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291, 1297, 1301, 1303, 1307, 1319};

    public static boolean isPresentedByInterface(Class<?> target, Class<?> intf) {
        Class<?> temp = target;
        boolean isValidClass = false;
        while (!temp.getName().equals(Object.class.getName())) {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = temp.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> intf0 = classArray[n2];
                if (intf0.equals(intf0)) {
                    isValidClass = true;
                    break;
                }
                ++n2;
            }
            if (isValidClass) break;
            temp = temp.getSuperclass();
        }
        return isValidClass;
    }

    public static List<Method> getAnnotationPresentedMethods(Class<?> cls, Class<? extends Annotation> annotation) {
        Method[] methods = cls.getMethods();
        ArrayList<Method> methodAry = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(annotation)) {
                methodAry.add(method);
            }
            ++n2;
        }
        return methodAry;
    }

    public static List<Field> getAnnotationPresentedField(Class<?> cls, Class<? extends Annotation> annotation) {
        Field[] fields = cls.getDeclaredFields();
        ArrayList<Field> fieldAry = new ArrayList<Field>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(annotation)) {
                fieldAry.add(field);
            }
            ++n2;
        }
        return fieldAry;
    }

    public static Class<?>[] getGenericTypeForMethodReturn(Method method) {
        Class[] resultTypes = null;
        Type aType = method.getGenericReturnType();
        if (aType != null) {
            Type[] types;
            ParameterizedType paramType = null;
            try {
                paramType = (ParameterizedType)aType;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (paramType != null && (types = paramType.getActualTypeArguments()) != null && types.length > 0) {
                resultTypes = new Class[types.length];
                int count = 0;
                Type[] typeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    Type type = typeArray[n2];
                    resultTypes[count] = (Class)type;
                    ++count;
                    ++n2;
                }
            }
        }
        return resultTypes;
    }

    public static void main(String[] args) {
    }

    public static class AttributeContext
    implements Comparator<AttributeContext>,
    Comparable<AttributeContext> {
        protected String attributeName;
        protected Class<?> presentedClass;
        protected boolean isBoolPresend;
        protected boolean hasGetter;
        protected boolean hasSetter;

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getGetterName() {
            return PREFIX.GETTER.camelCaseTo(this.attributeName);
        }

        public String getGetterBoolName() {
            return PREFIX.GETTER_BOOL.camelCaseTo(this.attributeName);
        }

        public String getSetterName() {
            return PREFIX.SETTER.camelCaseTo(this.attributeName);
        }

        public boolean isBoolPresend() {
            return this.isBoolPresend;
        }

        public boolean isHasGetter() {
            return this.hasGetter;
        }

        public boolean isHasSetter() {
            return this.hasSetter;
        }

        public Class<?> getPresentedClass() {
            return this.presentedClass;
        }

        public Object getInitialValue() {
            Constable result = null;
            if (this.presentedClass.isPrimitive()) {
                if (this.presentedClass.equals(Integer.TYPE)) {
                    result = 0;
                } else if (this.presentedClass.equals(Long.TYPE)) {
                    result = 0L;
                } else if (this.presentedClass.equals(Float.TYPE)) {
                    result = Float.valueOf(0.0f);
                } else if (this.presentedClass.equals(Double.TYPE)) {
                    result = 0.0;
                } else if (this.presentedClass.equals(Byte.TYPE)) {
                    result = Byte.valueOf("");
                } else if (this.presentedClass.equals(Short.TYPE)) {
                    result = Short.valueOf("");
                } else if (this.presentedClass.equals(Character.TYPE)) {
                    char val = ' ';
                    result = Character.valueOf(val);
                } else if (this.presentedClass.equals(Boolean.TYPE)) {
                    result = Boolean.valueOf(false);
                }
            } else {
                result = null;
            }
            return result;
        }

        public static AttributeContext[] getSetterSummary(Class<?> cls) {
            AttributeContext[] contextAry = null;
            if (cls == null) {
                contextAry = new AttributeContext[]{};
            }
            return contextAry;
        }

        public static AttributeContext[] getGetterSummary(Class<?> cls) {
            AttributeContext[] contextAry = null;
            if (cls == null) {
                contextAry = new AttributeContext[]{};
            }
            return contextAry;
        }

        public static AttributeContext[] getAccessorSummary(Class<?> cls) {
            AttributeContext[] contextAry = null;
            if (cls == null) {
                contextAry = new AttributeContext[]{};
            }
            return contextAry;
        }

        public static AttributeContext[] getOperatorSummary(Class<?> cls) {
            AttributeContext[] contextAry = null;
            if (cls == null) {
                contextAry = new AttributeContext[]{};
            }
            return contextAry;
        }

        public static Set<AttributeContext> getContexts(Class<?> cls) {
            TreeSet<AttributeContext> result = new TreeSet<AttributeContext>();
            if (cls == null) {
                return result;
            }
            Method[] methodArray = cls.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                AttributeContext attr = new AttributeContext(method, cls);
                result.add(attr);
                ++n2;
            }
            return result;
        }

        public AttributeContext(Method method, Class<?> cls) {
            String propertyName;
            String methodName = method.getName();
            PREFIX prefix = PREFIX.getPrefix(methodName);
            this.attributeName = propertyName = prefix.camelCaseOf(methodName);
            if (method == null || cls == null) {
                this.isBoolPresend = false;
                this.hasGetter = false;
                this.hasSetter = false;
                return;
            }
            if (method.getModifiers() != 1 && !cls.isInterface()) {
                LoggerFactory.getLogger(ReflectUtil.class).info("invalid method<{}> {}", (Object)method.getName(), (Object)"method modifier is not <public>");
                this.isBoolPresend = false;
                this.hasGetter = false;
                this.hasSetter = false;
                return;
            }
            if (method.getModifiers() == 8) {
                LoggerFactory.getLogger(ReflectUtil.class).info("invalid method<{}> {}", (Object)method.getName(), (Object)"method modifier is <static>");
                this.isBoolPresend = false;
                this.hasGetter = false;
                this.hasSetter = false;
                return;
            }
            switch (prefix) {
                case GETTER: {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes != null && parameterTypes.length > 0) {
                        this.isBoolPresend = false;
                        this.hasGetter = false;
                        this.hasSetter = false;
                        return;
                    }
                    this.hasGetter = true;
                    String setterMethodName = PREFIX.SETTER.camelCaseTo(propertyName);
                    Class<?> returnType = method.getReturnType();
                    returnType.equals(Boolean.TYPE);
                    this.presentedClass = returnType;
                    try {
                        cls.getDeclaredMethod(setterMethodName, returnType);
                        this.hasSetter = true;
                    }
                    catch (SecurityException e) {
                        this.hasSetter = false;
                    }
                    catch (NoSuchMethodException e) {
                        this.hasSetter = false;
                    }
                    break;
                }
                case SETTER: {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes == null || parameterTypes.length != 1) {
                        this.isBoolPresend = false;
                        this.hasGetter = false;
                        this.hasSetter = false;
                        return;
                    }
                    Class<?> parameterType = parameterTypes[0];
                    this.presentedClass = parameterType;
                    if (!parameterType.equals(Boolean.TYPE)) {
                        String getterMethodName = PREFIX.GETTER.camelCaseTo(propertyName);
                        try {
                            Method getterM = cls.getDeclaredMethod(getterMethodName, new Class[0]);
                            if (getterM.getParameterTypes().length == 0) {
                                if (getterM.getReturnType().equals(this.presentedClass)) {
                                    this.isBoolPresend = false;
                                    this.hasGetter = true;
                                    this.hasSetter = true;
                                    break;
                                }
                                this.isBoolPresend = false;
                                this.hasGetter = false;
                                this.hasSetter = true;
                                break;
                            }
                            this.isBoolPresend = false;
                            this.hasGetter = false;
                            this.hasSetter = true;
                        }
                        catch (SecurityException e) {
                            this.isBoolPresend = false;
                            this.hasGetter = false;
                            this.hasSetter = true;
                        }
                        catch (NoSuchMethodException e) {
                            this.isBoolPresend = false;
                            this.hasGetter = false;
                            this.hasSetter = true;
                        }
                        break;
                    }
                    String getterBoolMethodName = PREFIX.GETTER_BOOL.camelCaseTo(propertyName);
                    try {
                        Method getterBoolM = cls.getDeclaredMethod(getterBoolMethodName, new Class[0]);
                        if (getterBoolM.getReturnType().equals(Boolean.TYPE)) {
                            this.isBoolPresend = true;
                            this.hasGetter = false;
                            this.hasSetter = true;
                            break;
                        }
                        this.isBoolPresend = false;
                        this.hasGetter = false;
                        this.hasSetter = true;
                    }
                    catch (SecurityException e) {
                        this.isBoolPresend = false;
                        this.hasGetter = false;
                        this.hasSetter = true;
                    }
                    catch (NoSuchMethodException e) {
                        this.isBoolPresend = false;
                        this.hasGetter = false;
                        this.hasSetter = true;
                    }
                    break;
                }
                case GETTER_BOOL: {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes != null && parameterTypes.length > 0) {
                        this.isBoolPresend = false;
                        this.hasGetter = false;
                        this.hasSetter = false;
                        return;
                    }
                    Class<?> returnType = method.getReturnType();
                    this.presentedClass = returnType;
                    if (returnType.equals(Boolean.TYPE)) {
                        String setterMethodName = PREFIX.SETTER.camelCaseTo(propertyName);
                        try {
                            Method getterBoolM = cls.getDeclaredMethod(setterMethodName, returnType);
                            if (getterBoolM.getReturnType().equals(Void.TYPE)) {
                                this.isBoolPresend = true;
                                this.hasGetter = false;
                                this.hasSetter = true;
                                break;
                            }
                            this.isBoolPresend = true;
                            this.hasGetter = false;
                            this.hasSetter = false;
                        }
                        catch (SecurityException e) {
                            this.isBoolPresend = true;
                            this.hasGetter = false;
                            this.hasSetter = false;
                        }
                        catch (NoSuchMethodException e) {
                            this.isBoolPresend = true;
                            this.hasGetter = false;
                            this.hasSetter = false;
                        }
                        break;
                    }
                    this.isBoolPresend = false;
                    this.hasGetter = false;
                    this.hasSetter = false;
                    break;
                }
            }
        }

        public boolean isValidProperty() {
            return this.hasGetter || this.hasSetter || this.isBoolPresend;
        }

        public String toString() {
            String result = "attribute name[" + this.attributeName + "]" + " presented[" + this.presentedClass.getCanonicalName() + "]" + " get[" + this.hasGetter + "]" + " set[" + this.hasSetter + "]" + " is[" + this.isBoolPresend + "]";
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
            result = 31 * result + (this.hasGetter ? 1231 : 1237);
            result = 31 * result + (this.hasSetter ? 1249 : 1259);
            result = 31 * result + (this.isBoolPresend ? 1277 : 1279);
            result = 31 * result + (this.presentedClass == null ? 0 : this.presentedClass.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttributeContext other = (AttributeContext)obj;
            if (this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName)) {
                return false;
            }
            if (this.hasGetter != other.hasGetter) {
                return false;
            }
            if (this.hasSetter != other.hasSetter) {
                return false;
            }
            if (this.isBoolPresend != other.isBoolPresend) {
                return false;
            }
            return !(this.presentedClass == null ? other.presentedClass != null : !this.presentedClass.equals(other.presentedClass));
        }

        @Override
        public int compare(AttributeContext o1, AttributeContext o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            String s1 = o1.getAttributeName();
            String s2 = o2.getAttributeName();
            return s1.compareTo(s2);
        }

        @Override
        public int compareTo(AttributeContext o) {
            return this.compare(this, o);
        }
    }

    public static class AttributeContextComparator
    implements Comparator<AttributeContext> {
        private static AttributeContextComparator ME;

        private AttributeContextComparator() {
        }

        @Override
        public int compare(AttributeContext o1, AttributeContext o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            String s1 = o1.getAttributeName();
            String s2 = o2.getAttributeName();
            return s1.compareTo(s2);
        }

        public static AttributeContextComparator getInstance() {
            if (ME == null) {
                ME = new AttributeContextComparator();
            }
            return ME;
        }
    }

    public static enum PREFIX {
        GETTER{

            @Override
            public String prefix() {
                return GETTER_PREFIX;
            }
        }
        ,
        GETTER_BOOL{

            @Override
            public String prefix() {
                return GETTER_BOOL_PREFIX;
            }
        }
        ,
        SETTER{

            @Override
            public String prefix() {
                return SETTER_PREFIX;
            }
        }
        ,
        OTHER{

            @Override
            public String prefix() {
                return "";
            }
        };

        private static String GETTER_PREFIX;
        private static String GETTER_BOOL_PREFIX;
        private static String SETTER_PREFIX;

        static {
            GETTER_PREFIX = "get";
            GETTER_BOOL_PREFIX = "is";
            SETTER_PREFIX = "set";
        }

        public abstract String prefix();

        public String camelCaseOf(String methodName) {
            if (OTHER.equals((Object)this)) {
                return methodName;
            }
            if (GETTER_BOOL.equals((Object)this)) {
                if (methodName.length() < 3) {
                    return methodName;
                }
                String suffix = methodName.substring(2, methodName.length());
                String firstChar = suffix.substring(0, 1).toLowerCase();
                String otherChar = suffix.substring(1, suffix.length());
                String result = firstChar + otherChar;
                return result;
            }
            if (methodName.length() < 4) {
                return methodName;
            }
            String suffix = methodName.substring(3, methodName.length());
            String firstChar = suffix.substring(0, 1).toLowerCase();
            String otherChar = suffix.substring(1, suffix.length());
            String result = firstChar + otherChar;
            return result;
        }

        public String camelCaseTo(String propertyName) {
            if (propertyName == null) {
                return "";
            }
            if (propertyName.isEmpty()) {
                return "";
            }
            if (OTHER.equals((Object)this)) {
                return propertyName;
            }
            String pre = propertyName.substring(0, 1).toUpperCase();
            String other = propertyName.substring(1, propertyName.length());
            String result = this.prefix() + pre + other;
            return result;
        }

        public static PREFIX getPrefix(String methodName) {
            if (methodName.startsWith(GETTER_PREFIX)) {
                return GETTER;
            }
            if (methodName.startsWith(SETTER_PREFIX)) {
                return SETTER;
            }
            if (methodName.startsWith(GETTER_BOOL_PREFIX)) {
                return GETTER_BOOL;
            }
            return OTHER;
        }
    }
}

