/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.dyndns.nuda.management.RUN_STATE;
import org.dyndns.nuda.plugin.PluginLoader;
import org.dyndns.nuda.tools.regex.annotation.Regex;
import org.dyndns.nuda.tools.regex.plugins.CachePlugin;
import org.dyndns.nuda.tools.regex.plugins.ParserPlugin;
import org.dyndns.nuda.tools.regex.plugins.ProcessorPlugin;
import org.dyndns.nuda.tools.regex.processors.AutoInputSequenceProcessor;
import org.dyndns.nuda.tools.regex.processors.InputSequenceProcessor;
import org.dyndns.nuda.tools.regex.reflection.cache.CacheManager;
import org.dyndns.nuda.tools.regex.reflection.cache.FieldCache;
import org.dyndns.nuda.tools.regex.reflection.cache.MethodCache;
import org.dyndns.nuda.tools.regex.settings.JAutoRegexerSettings;
import org.dyndns.nuda.tools.regex.util.CommonToolsVersionCheck;
import org.dyndns.nuda.tools.regex.util.RegexPatternFactory;
import org.dyndns.nuda.tools.regex.util.exception.RegexPatternException;
import org.dyndns.nuda.tools.util.StringUtil;

public class RegexProcessor {
    private static InputSequenceProcessor processor;
    private static MethodCache filterCache;
    private static FieldCache fieldCache;
    private static final int requireCommonVersion = 1301;
    private static RUN_STATE STATE;

    static {
        STATE = RUN_STATE.SLEEP;
    }

    public RegexProcessor() {
        boolean isValidVersion = CommonToolsVersionCheck.isValidVersion(1301);
        if (!isValidVersion) {
            int toolVersion = CommonToolsVersionCheck.getToolsVersion();
            String message = StringUtil.format((String)"CommonTools\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u53e4\u3044\u305f\u3081\u30e9\u30a4\u30d6\u30e9\u30ea\u3092\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093:[\u8981\u6c42Ver:{}][\u4f7f\u7528Ver:{}]", (Object[])new Object[]{CommonToolsVersionCheck.getToolsVersionString(1301), CommonToolsVersionCheck.getToolsVersionString(toolVersion)});
            throw new RuntimeException(message);
        }
        if (STATE.equals((Object)RUN_STATE.SLEEP)) {
            PluginLoader loader = new PluginLoader();
            loader.loadPlugin(JAutoRegexerSettings.class);
            loader.loadPlugin(CachePlugin.class);
            loader.loadPlugin(ParserPlugin.class);
            loader.loadPlugin(ProcessorPlugin.class);
            filterCache = CacheManager.getMethodCache();
            fieldCache = CacheManager.getFieldCache();
            processor = AutoInputSequenceProcessor.getInstance();
            STATE = RUN_STATE.RUNNING;
        }
    }

    public <T> List<T> process(String source, Class<T> cls) {
        ArrayList<T> resultList = new ArrayList<T>();
        if (source == null) {
            return resultList;
        }
        if (cls == null) {
            return resultList;
        }
        try {
            Pattern pattern = RegexPatternFactory.createPattern(cls);
            Matcher matcher = pattern.matcher(source);
            Map<Integer, List<Field>> fieldMap = fieldCache.getTargetFieldList(cls);
            while (matcher.find()) {
                T instance = cls.newInstance();
                for (Map.Entry<Integer, List<Field>> entry : fieldMap.entrySet()) {
                    List<Field> l = fieldMap.get(entry.getKey());
                    for (Field targetField : l) {
                        String inputSequence = matcher.group(entry.getKey());
                        String mes = StringUtil.format((String)"class[{}] source[{}] regex[{}] inputSequence[{}]", (Object[])new Object[]{cls.getCanonicalName(), source, pattern.toString(), inputSequence});
                        if (!processor.accept(targetField, inputSequence)) continue;
                        processor.process(targetField, instance, inputSequence);
                    }
                }
                resultList.add(instance);
            }
            return resultList;
        }
        catch (PatternSyntaxException e) {
            return resultList;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return resultList;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return resultList;
        }
        catch (RegexPatternException e) {
            e.printStackTrace();
            return resultList;
        }
    }

    public <T> T processBySingle(String source, Class<T> cls) {
        block11: {
            if (cls != null) break block11;
            return null;
        }
        try {
            Object result = cls.newInstance();
            if (source == null) {
                return result;
            }
            if (!cls.isAnnotationPresent(Regex.class)) {
                if (result.getClass().getCanonicalName().equals("java.lang.String")) {
                    result = "";
                    return result;
                }
                return result;
            }
            Pattern pattern = RegexPatternFactory.createPattern(cls);
            Matcher matcher = pattern.matcher(source);
            Map<Integer, List<Field>> fieldMap = fieldCache.getTargetFieldList(cls);
            if (matcher.find()) {
                T instance = cls.newInstance();
                for (Map.Entry<Integer, List<Field>> entry : fieldMap.entrySet()) {
                    for (Field targetField : fieldMap.get(entry.getKey())) {
                        String inputSequence;
                        if (!processor.accept(targetField, inputSequence = matcher.group(entry.getKey()))) continue;
                        processor.process(targetField, instance, inputSequence);
                    }
                }
                result = instance;
            }
            return result;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (RegexPatternException e) {
            e.printStackTrace();
            return null;
        }
    }
}

