/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.tools.regex.util;

import java.util.regex.Pattern;
import org.dyndns.nuda.tools.regex.annotation.Regex;
import org.dyndns.nuda.tools.regex.reflection.cache.CacheManager;
import org.dyndns.nuda.tools.regex.reflection.cache.NoCachedRegexCache;
import org.dyndns.nuda.tools.regex.util.exception.RegexPatternException;
import org.dyndns.nuda.tools.util.StringUtil;

public class RegexPatternFactory {
    public static <T> int getRegexFlg(Class<T> cls) throws RegexPatternException {
        if (RegexPatternFactory.isValidClass(cls)) {
            return CacheManager.getRegexCache().getRegexFlg(cls);
        }
        String message = StringUtil.format((String)"\u30af\u30e9\u30b9[{}]\u306f\u59a5\u5f53\u306aRegexBean\u3067\u306f\u3042\u308a\u307e\u305b\u3093", (Object[])new Object[]{cls.getCanonicalName()});
        throw new RegexPatternException(message);
    }

    public static <T> Pattern createPattern(Class<T> cls) throws RegexPatternException {
        if (RegexPatternFactory.isValidClass(cls)) {
            Regex regex = cls.getAnnotation(Regex.class);
            if (regex.useCache()) {
                return CacheManager.getRegexCache().createPattern(cls);
            }
            return NoCachedRegexCache.getInstance().createPattern(cls);
        }
        String message = StringUtil.format((String)"\u30af\u30e9\u30b9[{}]\u306f\u59a5\u5f53\u306aRegexBean\u3067\u306f\u3042\u308a\u307e\u305b\u3093", (Object[])new Object[]{cls.getCanonicalName()});
        throw new RegexPatternException(message);
    }

    private static boolean isValidClass(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        return cls.isAnnotationPresent(Regex.class);
    }
}

