package org.dyndns.nuda.tools.regex.reflection.cache;

public class CacheManager {
	private static FieldCache fieldCache = null;
	private static MethodCache methodCache = null;
	private static RegexCache regexCache = null;

	public static void setFieldCache(FieldCache cache) {
		fieldCache = cache;
	}

	public static void setMethodCache(MethodCache cache) {
		methodCache = cache;
	}
	public static void setRegexCache(RegexCache cache) {
		regexCache = cache;
	}

	public static FieldCache getFieldCache() {
		if (fieldCache == null) {
			return TargetFieldCache.getInstance();
		} else {
			return fieldCache;
		}
	}

	public static MethodCache getMethodCache() {
		if (methodCache == null) {
			return TargetMethodCache.getInstance();
		} else {
			return methodCache;
		}
	}
	
	public static RegexCache getRegexCache() {
		if(regexCache == null) {
			return DefaultRegexCache.getInstance();
		} else  {
			return regexCache;
		}
	}
}
