package org.dyndns.nuda.tools.regex.processors;

import java.lang.reflect.Field;
import java.util.List;

import org.dyndns.nuda.tools.regex.RegexProcessor;
import org.dyndns.nuda.tools.regex.annotation.Regex;
import org.dyndns.nuda.tools.util.ReflectUtil;

public class ListRegexInputSequenceProcessor implements InputSequenceProcessor {

	@Override
	public boolean accept(Field targetField, String inputSequence) {
		Class<?> targetClass = targetField.getType();
		//System.out.println("ListRegexInputSequenceProcessor:accept:" + targetClass.getCanonicalName());
		if(List.class.equals(targetClass)) {
			
			Class<?> componentType = ReflectUtil.getParameterGenericType(targetField);
			if(componentType.isAnnotationPresent(Regex.class)) {
				//System.out.println("ListRegexInputSequenceProcessor:accepted:" + componentType.getCanonicalName());
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	@Override
	public void process(Field targetField, Object instance, String inputSequence) {
		//System.out.println("ListRegexInputSequenceProcessor:process");
		//Class<?> targetClass = targetField.getType();
		Class<?> componentType = ReflectUtil.getParameterGenericType(targetField);
		RegexProcessor rp = new RegexProcessor();
		
		java.util.List<?> result = rp.process(inputSequence, componentType);
		try {
			targetField.set(instance, result);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		}
	}

}
