/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.javacpt.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import jp.sourceforge.javacpt.ComparativePerformanceTest;
import jp.sourceforge.javacpt.Printer;
import jp.sourceforge.javacpt.impl.PrinterImpl;

public class ComparativePerformanceTestImpl
implements ComparativePerformanceTest {
    private String testName;
    private long startMillis;
    private long endMillis;
    private boolean printResultFlag = true;
    private Printer printer = null;

    private ComparativePerformanceTestImpl() {
        this.printer = new PrinterImpl();
    }

    public ComparativePerformanceTestImpl(String string) {
        this.testName = string;
        this.printer = new PrinterImpl();
    }

    @Override
    public void recordTestStart() {
        this.startMillis = System.currentTimeMillis();
    }

    @Override
    public void recordTestEnd() {
        this.endMillis = System.currentTimeMillis();
    }

    @Override
    public long getResult() {
        return this.endMillis - this.startMillis;
    }

    @Override
    public void setPrintResultFlag(boolean bl) {
        this.printResultFlag = bl;
    }

    @Override
    public void printResult() {
        if (this.printResultFlag) {
            String string = this.testName + " : " + String.valueOf(this.endMillis - this.startMillis) + "milsec.";
            this.printer.infoPrint(string);
        }
    }

    private void errorPrint(String string) {
        this.printer.errorPrint(string);
    }

    @Override
    public void repeat(int n, Object object, Method method, Object ... objectArray) {
        for (int i = 0; i < n; ++i) {
            try {
                method.invoke(object, objectArray);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.errorPrint("exception catched! : " + String.valueOf(i + 1) + "/" + n);
                illegalArgumentException.printStackTrace();
                break;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.errorPrint("exception catched! : " + String.valueOf(i + 1) + "/" + n);
                illegalAccessException.printStackTrace();
                break;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.errorPrint("exception catched! : " + String.valueOf(i + 1) + "/" + n);
                invocationTargetException.printStackTrace();
                break;
            }
        }
    }

    @Override
    public long execute(int n, Object object, Method method, Object ... objectArray) {
        this.recordTestStart();
        this.repeat(n, object, method, objectArray);
        this.recordTestEnd();
        this.printResult();
        return this.getResult();
    }

    @Override
    public Logger getLogger() {
        return this.printer.getLogger();
    }

    @Override
    public void setLogger(Logger logger) {
        this.printer.setLogger(logger);
    }
}

