package jp.sourceforge.javacpt.impl;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

import jp.sourceforge.javacpt.Printer;

public class PrinterImpl implements Printer
{

	private Logger logger;

	public PrinterImpl()
	{
	}

	public PrinterImpl(Logger logger)
	{
		this.logger = logger;
	}

	public void errorPrint(String msg)
	{
		if (logger != null)
		{
			try
			{
				errorPrint((Class<?>) ComparativePerformanceTestImpl.class,
						ComparativePerformanceTestImpl.class.getMethod("printResult",
								(Class[]) null), msg);
			} catch (Exception devonly)
			{
				devonly.printStackTrace();
			}
		} else
		{
			System.err.println(msg);
		}
	}

	public void errorPrint(Class<?> clazz, Method method, String msg)
	{
		if (logger != null)
		{
			this.logger.logp(Level.SEVERE, clazz.getName(), method.getName(), msg);
		} else
		{
			System.out.println(msg);
		}
	}

	public void infoPrint(Class<?> clazz, Method method, String msg)
	{
		if (logger != null)
		{
			this.logger.logp(Level.INFO, clazz.getName(), method.getName(), msg);
		} else
		{
			System.out.println(msg);
		}
	}

	public void infoPrint(String msg)
	{
		if (logger != null)
		{
			try
			{
				infoPrint((Class<?>) ComparativePerformanceTestImpl.class,
						ComparativePerformanceTestImpl.class.getMethod("printResult",
								(Class[]) null), msg);
			} catch (Exception devonly)
			{
				devonly.printStackTrace();
			}
		} else
		{
			System.out.println(msg);
		}
	}

	public Logger getLogger()
	{
		return logger;
	}

	public void setLogger(Logger logger)
	{
		this.logger = logger;
	}

}
