/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.javacpt.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import jp.sourceforge.javacpt.ComparativePerformanceTest;
import jp.sourceforge.javacpt.Printer;
import jp.sourceforge.javacpt.impl.PrinterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparativePerformanceTestImpl
implements ComparativePerformanceTest {
    private String testName;
    private long startMillis;
    private long endMillis;
    private boolean printResultFlag = true;
    private Printer printer = new PrinterImpl();
    public static final int DEFAULT_EXECUTE_TIMES = 1000;
    private int executeTimes = 1000;
    private Object target = null;

    public ComparativePerformanceTestImpl() {
    }

    public ComparativePerformanceTestImpl(String testName) {
        this.testName = testName;
    }

    @Override
    public void recordTestStart() {
        this.startMillis = System.currentTimeMillis();
    }

    @Override
    public void recordTestEnd() {
        this.endMillis = System.currentTimeMillis();
    }

    @Override
    public long getResult() {
        return this.endMillis - this.startMillis;
    }

    @Override
    public ComparativePerformanceTest setPrintResultFlag(boolean printResultFlag) {
        this.printResultFlag = printResultFlag;
        return this;
    }

    @Override
    public void printResult() {
        if (this.printResultFlag) {
            String result = this.testName + " : " + String.valueOf(this.endMillis - this.startMillis) + " milsec.";
            this.printer.infoPrint(result);
        }
    }

    @Override
    public void errorPrint(String str) {
        this.printer.errorPrint(str);
    }

    @Override
    public void repeat(int executeTimes, Object target, Method executeMethod, Object ... args) {
        if (target == null) {
            throw new IllegalStateException("Target instance or class to invoke method is required!");
        }
        for (int i = 0; i < executeTimes; ++i) {
            try {
                executeMethod.invoke(target, args);
                continue;
            }
            catch (IllegalArgumentException e) {
                String argsStr = "args : ";
                for (Object each : args) {
                    argsStr = argsStr + each.toString() + ",";
                }
                this.errorPrint("exception catched! : " + String.valueOf(i + 1) + "/" + executeTimes + "(" + argsStr + ")");
                e.printStackTrace();
                break;
            }
            catch (IllegalAccessException e) {
                this.errorPrint("exception catched! : " + String.valueOf(i + 1) + "/" + executeTimes);
                e.printStackTrace();
                break;
            }
            catch (InvocationTargetException e) {
                this.errorPrint("exception catched! : " + String.valueOf(i + 1) + "/" + executeTimes);
                e.printStackTrace();
                break;
            }
        }
    }

    @Override
    public long execute(int executeTimes, Object instance, Method executeMethod, Object ... args) {
        this.recordTestStart();
        this.repeat(executeTimes, instance, executeMethod, args);
        this.recordTestEnd();
        this.printResult();
        return this.getResult();
    }

    @Override
    public long execute(Method execuMethod, Object ... args) {
        return this.execute(this.executeTimes, this.target, execuMethod, args);
    }

    @Override
    public Logger getLogger() {
        return this.printer.getLogger();
    }

    @Override
    public ComparativePerformanceTest setLogger(Logger logger) {
        this.printer.setLogger(logger);
        return this;
    }

    @Override
    public int getExecuteTimes() {
        return this.executeTimes;
    }

    @Override
    public ComparativePerformanceTest setExecuteTimes(int executeTimes) {
        this.executeTimes = executeTimes;
        return this;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public ComparativePerformanceTest setTarget(Object target) {
        this.target = target;
        return this;
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public ComparativePerformanceTest setTestName(String testName) {
        this.testName = testName;
        return this;
    }

    @Override
    public Method getExecuteMethod(String methodName, Class<?>[] methodParamTypes) throws NoSuchMethodException, IllegalStateException {
        Method method = null;
        if (this.target == null) {
            throw new IllegalStateException("Target instance or class to invoke method is required!");
        }
        if (this.target instanceof Class) {
            Class targetClass = (Class)this.target;
            method = targetClass.getMethod(methodName, methodParamTypes);
        } else {
            method = this.target.getClass().getMethod(methodName, methodParamTypes);
        }
        return method;
    }
}

