/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */

package jp.sourceforge.javacpt;

import java.lang.reflect.Method;
import java.util.logging.Logger;

/**
 * ComparativePerformanceTest<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */
public interface ComparativePerformanceTest
{

	/**
	 * Execute loop test.
	 * 
	 * @param execuMethod
	 *            execute method object
	 * @param args
	 *            method parameters
	 * @return result millisec
	 */
	public long execute(Method execuMethod, Object... args);

	/**
	 * Execute loop test.
	 * 
	 * @param executeTimes
	 *            loop execute times
	 * @param instance
	 *            target instance(if execute instance method)
	 * @param executeMethod
	 *            execute method object
	 * @param args
	 *            method parameters
	 * @return result millisec
	 */
	public long execute(int executeTimes, Object instance, Method executeMethod,
			Object... args);

	/**
	 * Get result value
	 * 
	 * @return result millisec
	 */
	public long getResult();

	/**
	 * Print result value
	 * 
	 * @see Printer
	 */
	public void printResult();

	/**
	 * Print in ERROR level
	 * 
	 * @param str
	 *            String message to print
	 */
	public void errorPrint(String str);

	/**
	 * Record test start time(millisec)
	 */
	public void recordTestStart();

	/**
	 * Record test end time(millisec)
	 */
	public void recordTestEnd();

	/**
	 * Execute loop
	 * 
	 * @param executeTimes
	 *            loop execute times
	 * @param instance
	 *            target instance
	 * @param executeMethod
	 *            execute method object
	 * @param args
	 *            method parameters
	 */
	public void repeat(int executeTimes, Object instance, Method executeMethod,
			Object... args);

	/**
	 * Set printResultFlag
	 * 
	 * @param printResultFlag
	 */
	public ComparativePerformanceTest setPrintResultFlag(boolean printResultFlag);

	/**
	 * Get Logger
	 * 
	 * @return logger
	 */
	public Logger getLogger();

	/**
	 * Set Logger
	 * 
	 * @param logger
	 */
	public ComparativePerformanceTest setLogger(Logger logger);

	/**
	 * Get execute times
	 * 
	 * @return loop execute times
	 */
	public int getExecuteTimes();

	/**
	 * Set execute times
	 * 
	 * @param executeTimes
	 */
	public ComparativePerformanceTest setExecuteTimes(int executeTimes);

	/**
	 * Get target instance or class.
	 * 
	 * @return target instance
	 */
	public Object getTarget();

	/**
	 * Set target instance or class.
	 * 
	 * @param targetInstance
	 */
	public ComparativePerformanceTest setTarget(Object target);

	/**
	 * Get test name
	 * 
	 * @return test name
	 */
	public String getTestName();

	/**
	 * Set test name
	 * 
	 * @param testName
	 */
	public ComparativePerformanceTest setTestName(String testName);

	/**
	 * Get Execute Method
	 * 
	 * @param targetInstance
	 * @param methodName
	 * @param methodParamTypes
	 * @return method object
	 */
	public Method getExecuteMethod(String methodName, Class<?>[] methodParamTypes)
			throws NoSuchMethodException;

}