/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */
package jp.sourceforge.javacpt;

import java.util.logging.Logger;

/**
 * Printer<br>
 * <br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */
public interface Printer
{

	/**
	 * Print in INFO level
	 * 
	 * @param msg
	 *            String message to print
	 */
	public void infoPrint(String msg);

	/**
	 * Print in ERROR level
	 * 
	 * @param msg
	 *            String message to print
	 */
	public void errorPrint(String msg);

	/**
	 * get Logger
	 * 
	 * @return logger
	 */
	public Logger getLogger();

	/**
	 * set Logger
	 * 
	 * @param logger
	 */
	public void setLogger(Logger logger);

}
