/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.simplefh.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import jp.sourceforge.simplefh.ClassPathResource;
import jp.sourceforge.simplefh.SimpleFileAccessor;
import jp.sourceforge.simplefh.SimpleFileWriter;
import jp.sourceforge.simplefh.constant.FixedValue;
import jp.sourceforge.simplefh.impl.SimpleFileReaderImpl;
import jp.sourceforge.simplefh.impl.SimpleFileWriterImpl;
import jp.sourceforge.simplefh.util.FileResourceUtil;

public class SimpleFileAccessorImpl
implements SimpleFileAccessor {
    SimpleFileWriter writer = new SimpleFileWriterImpl();

    public String dirname(String path) {
        String[] tmpArr = path.split(FixedValue.DIR_SEPARATOR_REGEXP);
        StringBuffer sb = new StringBuffer();
        int len = tmpArr.length - 1;
        for (int i = 0; i < len; ++i) {
            sb.append(tmpArr[i]);
            sb.append("/");
        }
        return sb.toString();
    }

    public String dirname(File file) {
        String path = file.getPath();
        return this.dirname(path);
    }

    public String basename(String path) {
        String[] tmpArr = path.split(FixedValue.DIR_SEPARATOR_REGEXP);
        int basenameIdx = tmpArr.length - 1;
        return tmpArr[basenameIdx];
    }

    public String basename(File file) {
        String path = file.getPath();
        return this.basename(path);
    }

    public void copy(String src, String dest) throws IOException {
        FileChannel srcChannel = new FileInputStream(src).getChannel();
        FileChannel destChannel = new FileOutputStream(dest).getChannel();
        srcChannel.transferTo(0L, srcChannel.size(), destChannel);
    }

    public void copy(File srcFile, String dest) throws IOException {
        FileChannel srcChannel = new FileInputStream(srcFile).getChannel();
        FileChannel destChannel = new FileOutputStream(dest).getChannel();
        srcChannel.transferTo(0L, srcChannel.size(), destChannel);
    }

    public void copy(ClassPathResource src, ClassPathResource dest) throws IOException {
        String srcPath = src.getResourcePath();
        SimpleFileReaderImpl reader = new SimpleFileReaderImpl();
        srcPath = srcPath.replaceAll("\\\\", "/");
        byte[] srcByteArr = reader.read2ByteArray(srcPath);
        SimpleFileWriterImpl writer = new SimpleFileWriterImpl();
        try {
            writer.setWriteTarget(dest).write(srcByteArr);
        }
        catch (IOException e) {
            throw new IOException("Cannot copy resource file (destination file locked : " + dest.getResourcePath() + ")");
        }
    }

    public void delete(String filepath) throws IOException {
        File targetFile = new File(filepath);
        this.delete(targetFile);
    }

    public void delete(ClassPathResource resourcePath) throws IOException {
        String path = resourcePath.getResourcePath();
        String abPath = FileResourceUtil.getFileSystemAbsolutePath(path);
        if (!FileResourceUtil.isFileAccessAvailable(abPath)) {
            throw new IOException("Cannot delete resource file from archive file : " + abPath);
        }
        this.delete(abPath);
    }

    public void delete(File targetFile) throws IOException {
        if (!targetFile.delete()) {
            throw new IOException("Delete execute error : " + targetFile.getAbsolutePath());
        }
    }

    public void deleteIfExists(String path) throws IOException {
        File targetFile = new File(path);
        this.deleteIfExists(targetFile);
    }

    public void deleteIfExists(ClassPathResource resourcePath) throws IOException {
        String path = resourcePath.getResourcePath();
        String abPath = FileResourceUtil.getFileSystemAbsolutePath(path);
        if (!FileResourceUtil.isFileAccessAvailable(abPath)) {
            throw new IOException("Cannot delete resource file from archive file : " + abPath);
        }
        this.deleteIfExists(new File(abPath));
    }

    public void deleteIfExists(File targetFile) throws IOException {
        targetFile.deleteOnExit();
    }

    public void move(String fromPath, String toPath) throws IOException {
        File targetFile = new File(fromPath);
        try {
            this.move(targetFile, toPath);
        }
        catch (IOException e) {
            throw new IOException("Cannot move file from : " + fromPath + ", to : " + toPath);
        }
    }

    public void move(ClassPathResource from, ClassPathResource to) throws IOException {
        String fromPath = from.getResourcePath();
        String abFromPath = FileResourceUtil.getFileSystemAbsolutePath(fromPath);
        String rootPath = FileResourceUtil.getResourceRootPath(fromPath, abFromPath);
        String abToPath = rootPath + to.getResourcePath();
        if (!FileResourceUtil.isFileAccessAvailable(abFromPath)) {
            throw new IOException("Cannot move resource file from archive file : " + abFromPath);
        }
        this.move(abFromPath, abToPath);
    }

    public void move(File targetFile, String toPath) throws IOException {
        if (!targetFile.exists()) {
            throw new IOException("Cannot find move target file : " + targetFile.getAbsolutePath());
        }
        File dest = new File(toPath);
        if (dest.exists()) {
            try {
                this.delete(dest);
            }
            catch (IOException e) {
                throw new IOException("The destination file has already existed and cannot remove it(maybe locked) : " + toPath);
            }
        }
        if (!targetFile.renameTo(new File(toPath))) {
            throw new IOException("Cannot move file from : " + targetFile.getPath() + ", to : " + toPath);
        }
    }

    public void rename(String path, String newFilename) throws IOException {
        File targetFile = new File(path);
        this.rename(targetFile, newFilename);
    }

    public void rename(ClassPathResource resource, String newFilename) throws IOException {
        String path = resource.getResourcePath();
        String abPath = FileResourceUtil.getFileSystemAbsolutePath(path);
        if (!FileResourceUtil.isFileAccessAvailable(abPath)) {
            throw new IOException("Cannot rename resource file from archive file : " + abPath);
        }
        this.rename(abPath, newFilename);
    }

    public void rename(File file, String newFilename) throws IOException {
        if (!file.exists()) {
            throw new IOException("Cannot find rename target file : " + file.getAbsolutePath());
        }
        File dest = new File(this.dirname(file) + newFilename);
        if (dest.exists()) {
            try {
                this.delete(dest);
            }
            catch (IOException e) {
                throw new IOException("The destination file has already existed and cannot remove it(maybe locked) : " + dest.getAbsolutePath());
            }
        }
        if (!file.renameTo(dest)) {
            throw new IOException("Cannot rename file from : " + file.getPath() + ", to : " + newFilename);
        }
    }

    public void touch(String path) throws IOException {
        this.writer.setWriteTarget(path);
        byte[] bytes = new byte[]{};
        this.writer.write(bytes);
    }

    public void touch(ClassPathResource resourcePath) throws IOException {
        String path = resourcePath.getResourcePath();
        String abPath = FileResourceUtil.getFileSystemAbsolutePath(path);
        try {
            this.touch(abPath);
        }
        catch (IOException e) {
            throw new IOException("Cannot touch file in archive file : " + abPath);
        }
    }

    public void touch(File file) throws IOException {
        String path = file.getPath();
        this.writer.setWriteTarget(path);
        byte[] bytes = new byte[]{};
        this.writer.write(bytes);
    }

    public boolean fileExist(String path) {
        File targetFile = new File(path);
        return targetFile.exists();
    }

    public boolean fileExist(File file) {
        return file.exists();
    }

    public boolean fileExist(ClassPathResource resourcePath) {
        String path = resourcePath.getResourcePath();
        String abPath = FileResourceUtil.getFileSystemAbsolutePath(path);
        return this.fileExist(abPath);
    }
}

