/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.simplefh.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import jp.sourceforge.simplefh.ClassPathResource;
import jp.sourceforge.simplefh.SimpleFileWriter;
import jp.sourceforge.simplefh.util.FileResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFileWriterImpl
implements SimpleFileWriter {
    private String encoding = "MS932";
    private String writeTargetAbsolutePath = null;
    private String lineBreak = "\r\n";

    @Override
    public void write(String[] lines) throws IOException {
        StringBuffer sb = new StringBuffer();
        int len = lines.length;
        for (int i = 0; i < len; ++i) {
            sb.append(lines[i]);
            sb.append(this.lineBreak);
        }
        String strContent = sb.toString();
        this.write(strContent);
    }

    @Override
    public void write(List<String> lines) throws IOException {
        StringBuffer sb = new StringBuffer();
        int len = lines.size();
        for (int i = 0; i < len; ++i) {
            sb.append(lines.get(i));
            sb.append(this.lineBreak);
        }
        String strContent = sb.toString();
        this.write(strContent);
    }

    @Override
    public void write(String strContent) throws IOException {
        byte[] content = strContent.getBytes(this.encoding);
        this.write(content);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(byte[] content) throws IOException {
        FileOutputStream fos = null;
        try {
            if (!FileResourceUtil.isFileAccessAvailable(this.writeTargetAbsolutePath)) {
                throw new IOException("Cannot write to resource file in archive file : " + this.writeTargetAbsolutePath);
            }
            fos = new FileOutputStream(this.writeTargetAbsolutePath);
            fos.write(content);
        }
        catch (NullPointerException npe) {
            try {
                throw new IllegalStateException("The target file to write is required.");
                catch (IOException e) {
                    throw new IOException("Cannot write content to the target file : " + this.writeTargetAbsolutePath);
                }
            }
            catch (Throwable throwable) {
                FileResourceUtil.close(fos);
                throw throwable;
            }
        }
        FileResourceUtil.close(fos);
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public SimpleFileWriter setLineBreak(String lineBreak) {
        this.lineBreak = lineBreak;
        return this;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public SimpleFileWriter setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @Override
    public String getWriteTarget() {
        return this.writeTargetAbsolutePath;
    }

    @Override
    public SimpleFileWriter setWriteTarget(String path) {
        this.writeTargetAbsolutePath = path;
        return this;
    }

    @Override
    public SimpleFileWriter setWriteTarget(ClassPathResource resourcePath) {
        String absolutePath = FileResourceUtil.getFileSystemAbsolutePath(resourcePath.getResourcePath());
        return this.setWriteTarget(absolutePath);
    }

    @Override
    public SimpleFileWriter setWriteTarget(File file) {
        String absolutePath = file.getAbsolutePath();
        return this.setWriteTarget(absolutePath);
    }
}

