/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.simplefh.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.mozilla.universalchardet.UniversalDetector;

public class FileResourceUtil {
    public static boolean isFileAccessAvailable(String absolutePath) {
        if ((absolutePath = FileResourceUtil.getFileSystemAbsolutePath(absolutePath)).matches("^file\\:.*")) {
            return true;
        }
        return !absolutePath.matches("^jar\\:.*");
    }

    public static String getDetectedEncoding(InputStream is) throws IOException {
        int nread;
        UniversalDetector detector = new UniversalDetector(null);
        byte[] buf = new byte[4096];
        while ((nread = is.read(buf)) > 0 && !detector.isDone()) {
            detector.handleData(buf, 0, nread);
        }
        detector.dataEnd();
        return detector.getDetectedCharset();
    }

    public static String replaceAllBackSlash2Slash(String absolutePath) {
        return absolutePath.replaceAll("\\\\", "/");
    }

    public static String getFileSystemAbsolutePath(String resourcePathOrFilePath) {
        resourcePathOrFilePath = resourcePathOrFilePath.replaceAll("\\\\", "/");
        String absolutePath = null;
        URL url = FileResourceUtil.class.getClassLoader().getResource(resourcePathOrFilePath);
        if (url == null) {
            String parentDir = "";
            String[] pathArr = resourcePathOrFilePath.split("/");
            int pathArrLen = pathArr.length;
            for (int i = 0; i < pathArrLen - 1; ++i) {
                parentDir = parentDir + pathArr[i] + "/";
            }
            URL parentUrl = FileResourceUtil.class.getClassLoader().getResource(parentDir);
            if (parentUrl != null) {
                absolutePath = parentUrl.toString().replaceFirst("file:/", "") + pathArr[pathArrLen - 1];
            }
        }
        if (absolutePath == null) {
            absolutePath = url != null ? url.toString().replaceFirst("file:/", "") : resourcePathOrFilePath;
        }
        return absolutePath;
    }

    public static String getResourceRootPath(String resourcePath, String absolutePath) {
        resourcePath = resourcePath.replaceAll("\\\\", "/");
        String[] resArr = resourcePath.split("/");
        absolutePath = absolutePath.replace("\\\\", "/");
        String[] abArr = absolutePath.split("/");
        int abLen = abArr.length;
        int offset = 0;
        int rootPathIndex = 0;
        try {
            for (int i = 0; i < abLen; ++i) {
                if (offset == 0 && abArr[i].equals(resArr[offset])) {
                    rootPathIndex = i - 1;
                    ++offset;
                    continue;
                }
                if (!abArr[i].equals(resArr[offset])) continue;
                ++offset;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot get resource root path (resource path :" + resourcePath + ", absolute path : " + absolutePath + ")");
        }
        if (offset != resArr.length) {
            throw new IllegalArgumentException("Cannot get resource root path (resource path :" + resourcePath + ", absolute path : " + absolutePath + ")");
        }
        String retStr = "";
        for (int i = 0; i <= rootPathIndex; ++i) {
            retStr = retStr + abArr[i] + "/";
        }
        return retStr;
    }

    public static InputStream getInputStreamFromResourceOrFileSystem(String resourcePathOrFilePath) throws FileNotFoundException {
        resourcePathOrFilePath = FileResourceUtil.replaceAllBackSlash2Slash(resourcePathOrFilePath);
        InputStream is = FileResourceUtil.class.getClassLoader().getResourceAsStream(resourcePathOrFilePath);
        if (is == null) {
            is = new FileInputStream(resourcePathOrFilePath);
        }
        return is;
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(InputStreamReader isr) {
        try {
            if (isr != null) {
                isr.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(BufferedReader br) {
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(BufferedInputStream bis) {
        try {
            if (bis != null) {
                bis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(FileOutputStream fos) {
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

