/* 
 * Copyright 2009 Kazuhiro Sera. 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language 
 * governing permissions and limitations under the License. 
 */
package jp.sourceforge.simplefh.constant;

import java.io.File;

/**
 * Fixed value constants.<br>
 * 
 * @author Kazuhiro Sera
 * @version 1.0
 */
public final class FixedValue
{

	/**
	 * Empty String value
	 */
	public static final String EMPTY = "";

	/**
	 * Back slash
	 */
	public static final String BACK_SLASH = "\\";

	/**
	 * Escaped back slash
	 */
	public static final String BACK_SLASH_ESCAPED = "\\\\";

	/**
	 * Slash
	 */
	public static final String SLASH = "/";

	/**
	 * Pipe
	 */
	public static final String PIPE = "|";

	/**
	 * Directory separator (OS native)
	 */
	public static final String DIR_SEPARATOR = File.separator;

	/**
	 * Directory separator regexp value
	 */
	public static final String DIR_SEPARATOR_REGEXP;

	static
	{
		if (DIR_SEPARATOR.equals(BACK_SLASH))
		{
			DIR_SEPARATOR_REGEXP = BACK_SLASH + BACK_SLASH + PIPE + SLASH;
		} else
		{
			DIR_SEPARATOR_REGEXP = SLASH;
		}
	}

}
