/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.app.project.ProjectManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Perspective
implements IPerspectiveFactory {
    public static final String ID = "ch.kuramo.javie.app.perspective";
    public static final String ID_BOTTOM_FOLDER = "ch.kuramo.javie.app.perspective.bottomFolder";
    public static final String ID_LEFT_FOLDER = "ch.kuramo.javie.app.perspective.leftFolder";
    public static final String ID_CENTER_FOLDER = "ch.kuramo.javie.app.perspective.centerFolder";

    public void createInitialLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout bottomFolder = layout.createFolder(ID_BOTTOM_FOLDER, 4, 0.5f, editorArea);
        IFolderLayout leftFolder = layout.createFolder(ID_LEFT_FOLDER, 1, 0.3f, editorArea);
        IFolderLayout centerFolder = layout.createFolder(ID_CENTER_FOLDER, 1, 0.95f, editorArea);
        leftFolder.addPlaceholder("ch.kuramo.javie.app.views.projectView");
        leftFolder.addPlaceholder("org.eclipse.ui.console.ConsoleView");
        bottomFolder.addPlaceholder("ch.kuramo.javie.app.views.layerCompositionView:*");
        centerFolder.addPlaceholder("ch.kuramo.javie.app.views.mediaPlayerView:*");
        layout.setEditorAreaVisible(false);
    }

    public static void reset(IWorkbenchWindow window) {
        IPerspectiveRegistry registry = window.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor defaultPerspective = registry.findPerspectiveWithId(ID);
        IWorkbenchPage page = window.getActivePage();
        page.setPerspective(defaultPerspective);
        page.resetPerspective();
        Perspective.closeOther(page, defaultPerspective);
    }

    public static void openForProject(ProjectManager pm) {
        String id;
        IWorkbenchWindow window = pm.getWorkbenchWindow();
        IPerspectiveRegistry registry = window.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor perspective = registry.findPerspectiveWithId(id = Perspective.perspectiveId(pm));
        if (perspective != null) {
            IWorkbenchPage page = window.getActivePage();
            page.setPerspective(perspective);
            Perspective.closeOther(page, perspective);
        }
    }

    public static void saveForProject(ProjectManager pm) {
        String id;
        IWorkbenchWindow window = pm.getWorkbenchWindow();
        IPerspectiveRegistry registry = window.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor perspective = registry.findPerspectiveWithId(id = Perspective.perspectiveId(pm));
        if (perspective == null) {
            IPerspectiveDescriptor defaultPerspective = registry.findPerspectiveWithId(ID);
            perspective = registry.clonePerspective(id, id, defaultPerspective);
        }
        IWorkbenchPage page = window.getActivePage();
        page.savePerspectiveAs(perspective);
        Perspective.closeOther(page, perspective);
    }

    private static String perspectiveId(ProjectManager pm) {
        String path;
        try {
            path = pm.getFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            path = pm.getFile().getAbsolutePath();
        }
        return "ch.kuramo.javie.app.perspective." + pm.getProject().getId() + "." + path;
    }

    private static void closeOther(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = page.getOpenPerspectives();
        int n = iPerspectiveDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor pd = iPerspectiveDescriptorArray[n2];
            if (pd != perspective) {
                page.closePerspective(pd, false, false);
            }
            ++n2;
        }
    }

    public static void deleteOld(IWorkbench workbench, List<List<String>> retain) {
        HashSet<String> retainIds = new HashSet<String>();
        for (List<String> idAndPath : retain) {
            retainIds.add("ch.kuramo.javie.app.perspective." + idAndPath.get(0) + "." + idAndPath.get(1));
        }
        IPerspectiveRegistry registry = workbench.getPerspectiveRegistry();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = registry.getPerspectives();
        int n = iPerspectiveDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor pd = iPerspectiveDescriptorArray[n2];
            if (!retainIds.contains(pd.getId())) {
                registry.deletePerspective(pd);
            }
            ++n2;
        }
    }
}

