/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.core.JavieRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    public static <T> T getProperty(Object object, String property) {
        Class<?> clazz = object.getClass();
        String upperCamelCase = String.valueOf(Character.toUpperCase(property.charAt(0))) + property.substring(1);
        Method method = null;
        try {
            method = clazz.getMethod("get" + upperCamelCase, new Class[0]);
            if (method.getReturnType().equals(Void.TYPE)) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (method == null) {
            try {
                method = clazz.getMethod("is" + upperCamelCase, new Class[0]);
                if (!method.getReturnType().equals(Boolean.TYPE)) {
                    method = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("no such property found: class=%s, property=%s", clazz.getName(), property));
        }
        try {
            Object value = method.invoke(object, new Object[0]);
            return (T)value;
        }
        catch (IllegalAccessException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    public static <T> void setProperty(Object object, String property, T newValue) {
        Class<?> clazz = object.getClass();
        String methodName = "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
        Method method = null;
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> paramType;
            Method m = methodArray[n2];
            if (m.getName().equals(methodName) && m.getParameterTypes().length == 1 && m.getReturnType().equals(Void.TYPE) && (paramType = PropertyUtil.toWrapperType(m.getParameterTypes()[0])).isAssignableFrom(newValue.getClass())) {
                method = m;
                break;
            }
            ++n2;
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("no such property found: class=%s, property=%s", clazz.getName(), property));
        }
        try {
            method.invoke(object, newValue);
        }
        catch (IllegalAccessException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    private static Class<?> toWrapperType(Class<?> type) {
        return type.equals(Boolean.TYPE) ? Boolean.class : (type.equals(Character.TYPE) ? Character.class : (type.equals(Byte.TYPE) ? Byte.class : (type.equals(Short.TYPE) ? Short.class : (type.equals(Integer.TYPE) ? Integer.class : (type.equals(Long.TYPE) ? Long.class : (type.equals(Float.TYPE) ? Float.class : (type.equals(Double.TYPE) ? Double.class : (type.equals(Void.TYPE) ? Void.class : type))))))));
    }
}

