/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.player;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.services.GLGlobal;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedList;
import java.util.Queue;
import javax.media.opengl.GLCanvas;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GLCanvasFactory {
    private static final GLCanvasFactory factory = new GLCanvasFactory();
    private int _poolSize;
    private Queue<GLCanvasRecord> _pool;
    private Composite _holder;
    @Inject
    private GLGlobal _glGlobal;

    public static GLCanvasFactory getFactory() {
        return factory;
    }

    private GLCanvasFactory() {
        InjectorHolder.getInjector().injectMembers((Object)this);
    }

    public void enterPoolMode(int poolSize) {
        if (this._pool != null) {
            throw new IllegalStateException("already in pool mode");
        }
        if (poolSize <= 0) {
            throw new IllegalArgumentException("poolSize must be one or greater");
        }
        this._poolSize = poolSize;
        this._pool = new LinkedList<GLCanvasRecord>();
    }

    public boolean isPoolMode() {
        return this._pool != null;
    }

    public GLCanvasRecord getGLCanvas(Composite parent) {
        if (this._pool != null) {
            GLCanvasRecord record = this._pool.poll();
            if (record == null) {
                throw new JavieRuntimeException("no GLCanvas is available");
            }
            record.scrolled.setParent(parent);
            record.scrolled.setVisible(true);
            return record;
        }
        return this.newRecord(parent);
    }

    public void releaseGLCanvas(GLCanvasRecord record) {
        if (this._pool != null) {
            record.scrolled.setVisible(false);
            record.scrolled.setParent(this._holder);
            this._pool.offer(record);
        } else {
            record.scrolled.dispose();
        }
    }

    private GLCanvasRecord newRecord(Composite parent) {
        ScrolledComposite scrolled = new ScrolledComposite(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        scrolled.setBackground(parent.getDisplay().getSystemColor(16));
        Composite embedded = new Composite((Composite)scrolled, 0x1040000);
        scrolled.setContent((Control)embedded);
        Frame awtFrame = SWT_AWT.new_Frame((Composite)embedded);
        GridBagLayout gridBag = new GridBagLayout();
        awtFrame.setLayout(gridBag);
        awtFrame.setBackground(Color.GRAY);
        GLCanvas glCanvas = this._glGlobal.createCanvas();
        gridBag.setConstraints((Component)glCanvas, new GridBagConstraints());
        awtFrame.add((Component)glCanvas);
        return new GLCanvasRecord(scrolled, embedded, awtFrame, glCanvas);
    }

    private void initPool(Composite parent) {
        if (this._holder != null) {
            throw new IllegalStateException("pool is already initialized");
        }
        if (this._pool == null) {
            throw new IllegalStateException("not in pool mode");
        }
        this._holder = new Composite(parent, 0){
            private final Point size;
            {
                this.size = new Point(1, 1);
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return this.size;
            }
        };
        int i = 0;
        while (i < this._poolSize) {
            GLCanvasRecord record = this.newRecord(parent);
            record.glCanvas.display();
            this.releaseGLCanvas(record);
            ++i;
        }
    }

    public ControlContribution createControlContribution() {
        return new ControlContribution("GLCanvasFactory"){

            protected Control createControl(Composite parent) {
                GLCanvasFactory.this.initPool(parent);
                return GLCanvasFactory.this._holder;
            }
        };
    }

    public static class GLCanvasRecord {
        public final ScrolledComposite scrolled;
        public final Composite embedded;
        public final Frame awtFrame;
        public final GLCanvas glCanvas;

        public GLCanvasRecord(ScrolledComposite scrolled, Composite embedded, Frame awtFrame, GLCanvas glCanvas) {
            this.scrolled = scrolled;
            this.embedded = embedded;
            this.awtFrame = awtFrame;
            this.glCanvas = glCanvas;
        }
    }
}

