/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerSlipOperation
extends ProjectOperation {
    private final String _compId;
    private List<Entry> _entries = Util.newList();
    private final Object[][] _keyframeData;
    private final String[] _savedAvalues;
    private String[] _newAvalues;
    private Time _deltaTime;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public LayerSlipOperation(ProjectManager projectManager, LayerComposition comp, Object[][] layersAndStartTimes, Object[][] keyframeData, String[] baseAnimatableValues, Time deltaTime, String relation) {
        super(projectManager, "\u30ec\u30a4\u30e4\u30fc\u6642\u9593\u306e\u5909\u66f4", relation);
        InjectorHolder.getInjector().injectMembers((Object)this);
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        this._keyframeData = keyframeData;
        this._savedAvalues = new String[this._keyframeData.length];
        this._newAvalues = new String[this._keyframeData.length];
        this.init(comp, layersAndStartTimes, baseAnimatableValues, deltaTime);
    }

    private void init(LayerComposition comp, Object[][] layersAndStartTimes, String[] baseAnimatableValues, Time deltaTime) {
        Layer layer;
        Object[] o;
        Object[][] objectArray = layersAndStartTimes;
        int n = layersAndStartTimes.length;
        int n2 = 0;
        while (n2 < n) {
            Time duration;
            MediaInput input;
            o = objectArray[n2];
            layer = (Layer)o[0];
            if (layer instanceof MediaItemLayer && (input = ((MediaItemLayer)layer).getMediaInput()) != null && (duration = input.getDuration()) != null) {
                Time inPoint = layer.getInPoint();
                Time outPoint = layer.getOutPoint();
                Time startTime = (Time)o[1];
                Time endTime = startTime.add(new Time((long)((double)duration.timeValue / Math.abs(layer.getRate())), duration.timeScale));
                Time t = inPoint.subtract(startTime);
                if (t.before(deltaTime)) {
                    deltaTime = t;
                }
                if ((t = outPoint.subtract(endTime)).after(deltaTime)) {
                    deltaTime = t;
                }
            }
            ++n2;
        }
        objectArray = layersAndStartTimes;
        n = layersAndStartTimes.length;
        n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            layer = (Layer)o[0];
            Time newStartTime = ((Time)o[1]).add(deltaTime);
            Time oldStartTime = layer.getStartTime();
            this._entries.add(new Entry(layer.getId(), oldStartTime, newStartTime));
            if (newStartTime.equals((Object)oldStartTime)) {
                this._noEffect = true;
            }
            ++n2;
        }
        if (this._noEffect) {
            return;
        }
        this._deltaTime = deltaTime;
        AnimatableValue[] newAvalues = new AnimatableValue[this._keyframeData.length];
        Map map = Util.newMap();
        int i = 0;
        int n3 = this._keyframeData.length;
        while (i < n3) {
            AnimatableValue avalue;
            layer = comp.getLayer((String)this._keyframeData[i][0]);
            Integer effectIndex = (Integer)this._keyframeData[i][1];
            String property = (String)this._keyframeData[i][2];
            Keyframe kf = (Keyframe)this._keyframeData[i][3];
            if (effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            AnimatableValue newAvalue = (AnimatableValue)map.get(avalue);
            if (newAvalue == null) {
                this._savedAvalues[i] = this._encoder.encodeElement((Object)avalue);
                try {
                    newAvalue = (AnimatableValue)this._decoder.decodeElement((CharSequence)baseAnimatableValues[i], avalue.getClass());
                }
                catch (ProjectDecodeException e) {
                    throw new JavieRuntimeException((Throwable)e);
                }
                map.put(avalue, newAvalue);
                newAvalues[i] = newAvalue;
            }
            AnimatableValue tmp = newAvalue;
            tmp.putKeyframe(kf.time.add(deltaTime), kf.value, kf.interpolation);
            ++i;
        }
        i = 0;
        n3 = newAvalues.length;
        while (i < n3) {
            if (newAvalues[i] != null) {
                this._newAvalues[i] = this._encoder.encodeElement((Object)newAvalues[i]);
            }
            ++i;
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.slip(false, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.slip(true, project, pm);
        return Status.OK_STATUS;
    }

    private void slip(boolean undo, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List<Layer> data1 = this.modifyStartTime(undo, pm != null, comp);
        Object[][] data2 = this.shiftKeyframes(undo, pm != null, comp);
        if (pm != null) {
            pm.fireLayerSlipEdit(comp, new Object[]{data1, data2});
        }
    }

    private List<Layer> modifyStartTime(boolean undo, boolean createData, LayerComposition comp) {
        List layers = null;
        if (createData) {
            layers = Util.newList();
        }
        for (Entry e : this._entries) {
            Layer layer = comp.getLayer(e.layerId);
            layer.setStartTime(undo ? e.oldStartTime : e.newStartTime);
            if (!createData) continue;
            layers.add(layer);
        }
        return layers;
    }

    private Object[][] shiftKeyframes(boolean undo, boolean createData, LayerComposition comp) throws ExecutionException {
        Object[][] data = null;
        if (createData) {
            data = new Object[this._keyframeData.length][];
        }
        int i = 0;
        int n = this._keyframeData.length;
        while (i < n) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer((String)this._keyframeData[i][0]);
            Integer effectIndex = (Integer)this._keyframeData[i][1];
            String property = (String)this._keyframeData[i][2];
            Keyframe kf = (Keyframe)this._keyframeData[i][3];
            if (effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            if (undo) {
                if (this._savedAvalues[i] != null) {
                    this.restore(this._savedAvalues[i], avalue);
                }
                if (createData) {
                    data[i] = new Object[]{layer, effectIndex, property, kf.time};
                }
            } else {
                if (this._newAvalues[i] != null) {
                    this.restore(this._newAvalues[i], avalue);
                }
                if (createData) {
                    data[i] = new Object[]{layer, effectIndex, property, kf.time.add(this._deltaTime)};
                }
            }
            ++i;
        }
        return data;
    }

    private <A extends AnimatableValue<V>, V> void restore(String data, A dst) throws ExecutionException {
        try {
            AnimatableValue src = (AnimatableValue)this._decoder.decodeElement((CharSequence)data, dst.getClass());
            dst.clearKeyframes(src.getStaticValue());
            dst.setExpression(src.getExpression());
            for (Keyframe kf : src.getKeyframes()) {
                dst.putKeyframe(kf);
            }
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding AnimatableValue data", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            try {
                LayerSlipOperation layerSlipOperation = this;
                synchronized (layerSlipOperation) {
                    this.slip(false, project, null);
                }
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            return true;
        }
        if (!(operation instanceof LayerSlipOperation)) {
            return false;
        }
        LayerSlipOperation newOp = (LayerSlipOperation)operation;
        if (!newOp._compId.equals(this._compId) || newOp._entries.size() != this._entries.size() || newOp._keyframeData != this._keyframeData) {
            return false;
        }
        if (!newOp._deltaTime.equals((Object)this._deltaTime)) {
            List mergedEntries = Util.newList();
            int i22 = 0;
            int n = this._entries.size();
            while (i22 < n) {
                Entry oldEntry = this._entries.get(i22);
                Entry newEntry = newOp._entries.get(i22);
                if (!newEntry.layerId.equals(oldEntry.layerId)) {
                    return false;
                }
                mergedEntries.add(new Entry(oldEntry.layerId, oldEntry.oldStartTime, newEntry.newStartTime));
                ++i22;
            }
            LayerSlipOperation i22 = this;
            synchronized (i22) {
                this._entries = mergedEntries;
                this._newAvalues = newOp._newAvalues;
                this._deltaTime = newOp._deltaTime;
            }
            try {
                this.slip(false, project, pm);
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            this._noEffect = this._deltaTime.timeValue == 0L;
        }
        return true;
    }

    private class Entry {
        final String layerId;
        final Time oldStartTime;
        final Time newStartTime;

        public Entry(String layerId, Time oldStartTime, Time newStartTime) {
            this.layerId = layerId;
            this.oldStartTime = oldStartTime;
            this.newStartTime = newStartTime;
        }
    }
}

