/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveEffectsOperation
extends ProjectOperation {
    private final String _compId;
    private final String _srcLayerId;
    private final String _dstLayerId;
    private final List<Integer> _effectIndices = Util.newList();
    private final int _dstIndex;

    public MoveEffectsOperation(ProjectManager pm, EffectableLayer srcLayer, List<Effect> effects, EffectableLayer dstLayer, int moveBefore) {
        super(pm, "\u30a8\u30d5\u30a7\u30af\u30c8\u306e\u79fb\u52d5");
        LayerComposition comp = pm.checkLayer((Layer)srcLayer);
        if (pm.checkLayer((Layer)dstLayer) != comp) {
            throw new IllegalArgumentException();
        }
        this._compId = comp.getId();
        this._srcLayerId = srcLayer.getId();
        this._dstLayerId = dstLayer.getId();
        boolean sameLayer = srcLayer == dstLayer;
        int dstEffectCount = dstLayer.getEffects().size();
        int dstIndex = moveBefore < 0 || moveBefore > dstEffectCount ? (moveBefore = dstEffectCount) : moveBefore;
        for (Effect e : effects) {
            int index = srcLayer.getEffects().indexOf(e);
            if (index == -1) {
                throw new IllegalArgumentException();
            }
            this._effectIndices.add(index);
            if (!sameLayer || index >= moveBefore) continue;
            --dstIndex;
        }
        this._dstIndex = dstIndex;
        Collections.sort(this._effectIndices);
        if (sameLayer) {
            List tmp = Util.newList((Collection)srcLayer.getEffects());
            tmp.removeAll(effects);
            tmp.addAll(this._dstIndex, effects);
            this._noEffect = srcLayer.getEffects().equals(tmp);
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        EffectableLayer srcLayer = (EffectableLayer)comp.getLayer(this._srcLayerId);
        EffectableLayer dstLayer = (EffectableLayer)comp.getLayer(this._dstLayerId);
        List data = null;
        if (pm != null) {
            data = Util.newList();
        }
        List effects = Util.newList();
        for (int i : this._effectIndices) {
            effects.add((Effect)srcLayer.getEffects().get(i));
            if (pm == null) continue;
            data.add(new Object[]{dstLayer, this._dstIndex + data.size()});
        }
        srcLayer.getEffects().removeAll(effects);
        if (pm != null) {
            pm.fireEffectsRemove(comp, new Object[][]{{srcLayer, -1}});
        }
        dstLayer.getEffects().addAll(this._dstIndex, effects);
        if (pm != null) {
            pm.fireEffectsAdd(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        EffectableLayer srcLayer = (EffectableLayer)comp.getLayer(this._srcLayerId);
        EffectableLayer dstLayer = (EffectableLayer)comp.getLayer(this._dstLayerId);
        List data = null;
        if (pm != null) {
            data = Util.newList();
        }
        List effects = Util.newList(dstLayer.getEffects().subList(this._dstIndex, this._dstIndex + this._effectIndices.size()));
        dstLayer.getEffects().removeAll(effects);
        if (pm != null) {
            pm.fireEffectsRemove(comp, new Object[][]{{dstLayer, -1}});
        }
        int i = 0;
        int n = effects.size();
        while (i < n) {
            int j = this._effectIndices.get(i);
            srcLayer.getEffects().add(j, (Effect)effects.get(i));
            if (pm != null) {
                data.add(new Object[]{srcLayer, j});
            }
            ++i;
        }
        if (pm != null) {
            pm.fireEffectsAdd(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
        return Status.OK_STATUS;
    }
}

