/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewLayerFromItemOperation
extends ProjectOperation {
    private final String _compId;
    private final int _insertIndex;
    private final List<String> _layerData = Util.newList();
    private final List<String> _layerIds = Util.newList();
    @Inject
    private ProjectElementFactory _elementFactory;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public NewLayerFromItemOperation(ProjectManager projectManager, LayerComposition comp, int insertIndex, List<Item> items) {
        super(projectManager, "\u30ec\u30a4\u30e4\u30fc\u306e\u8ffd\u52a0");
        InjectorHolder.getInjector().injectMembers((Object)this);
        projectManager.checkComposition((Composition)comp);
        if (insertIndex < 0 || insertIndex > comp.getLayers().size()) {
            throw new IllegalArgumentException("insertIndex: " + insertIndex);
        }
        this._compId = comp.getId();
        this._insertIndex = insertIndex;
        Size2i compSize = comp.getSize();
        Vec3d compCenter = new Vec3d((double)compSize.width / 2.0, (double)compSize.height / 2.0);
        for (Item item : items) {
            projectManager.checkItem(item);
            if (item instanceof CompositionItem && this.checkCyclicComposition(comp, (CompositionItem)item)) continue;
            if (item instanceof MediaItem) {
                MediaItem mediaItem = (MediaItem)item;
                MediaItemLayer layer = this._elementFactory.newMediaItemLayer(mediaItem);
                if (layer == null) continue;
                MediaInput input = mediaItem.getMediaInput();
                Time duration = input.getDuration();
                if (duration == null) {
                    duration = comp.getDuration();
                }
                Time time0 = Time.fromFrameNumber((long)0L, (Time)comp.getFrameDuration());
                layer.setStartTime(time0);
                layer.setInPoint(time0);
                layer.setOutPoint(duration);
                if (LayerNature.isVideoNature((Layer)layer)) {
                    VideoBounds bounds = input.getVideoFrameBounds();
                    layer.getAnchorPoint().clearKeyframes((Object)new Vec3d((double)bounds.width / 2.0 + bounds.x, (double)bounds.height / 2.0 + bounds.y));
                    layer.getPosition().clearKeyframes((Object)compCenter);
                }
                this._layerData.add(this._encoder.encodeElement((Object)layer));
                this._layerIds.add(layer.getId());
                continue;
            }
            boolean cfr_ignored_0 = item instanceof Folder;
        }
        this._noEffect = this._layerData.isEmpty();
    }

    private boolean checkCyclicComposition(LayerComposition comp, CompositionItem compItem) {
        Composition otherComp = compItem.getComposition();
        if (otherComp == comp) {
            return true;
        }
        if (otherComp instanceof LayerComposition) {
            for (Layer layer : ((LayerComposition)otherComp).getLayers()) {
                MediaItem mi;
                if (!(layer instanceof MediaItemLayer) || !((mi = ((MediaItemLayer)layer).getItem()) instanceof CompositionItem) || !this.checkCyclicComposition(comp, (CompositionItem)mi)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List newLayers = Util.newList();
        try {
            for (String data : this._layerData) {
                newLayers.add((Layer)this._decoder.decodeElement((CharSequence)data, Layer.class));
            }
            for (Layer layer : newLayers) {
                layer.afterDecode(project, comp);
            }
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding layer data", (Throwable)e);
        }
        comp.getLayers().addAll(this._insertIndex, newLayers);
        if (pm != null) {
            pm.fireLayersAdd(comp, newLayers);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List layers = comp.getLayers().subList(this._insertIndex, this._insertIndex + this._layerIds.size());
        int i = 0;
        while (i < layers.size()) {
            if (!((Layer)layers.get(i)).getId().equals(this._layerIds.get(i))) {
                throw new ExecutionException("composition structure is corrupted");
            }
            ++i;
        }
        List removedLayers = Util.newList(layers);
        layers.clear();
        if (pm != null) {
            pm.fireLayersRemove(comp, removedLayers);
        }
        return Status.OK_STATUS;
    }
}

